% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_p_value.R, R/methods_emmeans.R
\name{p_value}
\alias{p_value}
\alias{p_value.default}
\alias{p_value.emmGrid}
\title{p-values}
\usage{
p_value(model, ...)

\method{p_value}{default}(
  model,
  dof = NULL,
  method = NULL,
  component = "all",
  vcov = NULL,
  vcov_args = NULL,
  verbose = TRUE,
  ...
)

\method{p_value}{emmGrid}(model, ci = 0.95, adjust = "none", ...)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Additional arguments}

\item{dof}{Number of degrees of freedom to be used when calculating
confidence intervals. If \code{NULL} (default), the degrees of freedom are
retrieved by calling \code{\link[=degrees_of_freedom]{degrees_of_freedom()}} with
approximation method defined in \code{method}. If not \code{NULL}, use this argument
to override the default degrees of freedom used to compute confidence
intervals.}

\item{method}{Method for computing degrees of freedom for
confidence intervals (CI) and the related p-values. Allowed are following
options (which vary depending on the model class): \code{"residual"},
\code{"normal"}, \code{"likelihood"}, \code{"satterthwaite"}, \code{"kenward"}, \code{"wald"},
\code{"profile"}, \code{"boot"}, \code{"uniroot"}, \code{"ml1"}, \code{"betwithin"}, \code{"hdi"},
\code{"quantile"}, \code{"ci"}, \code{"eti"}, \code{"si"}, \code{"bci"}, or \code{"bcai"}. See section
\emph{Confidence intervals and approximation of degrees of freedom} in
\code{\link[=model_parameters]{model_parameters()}} for further details.}

\item{component}{Model component for which parameters should be shown. See
the documentation for your object's class in \code{\link[=model_parameters]{model_parameters()}} or
\code{\link[=p_value]{p_value()}} for further details.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance matrix,
a function which returns a covariance matrix, or a string which identifies
the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"vcovHC"}, \code{"HC"}, \code{"HC0"}, \code{"HC1"},
\code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}.
\item Cluster-robust: \code{"vcovCR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"}, \code{"CR2"},
\code{"CR3"}. See \code{?clubSandwich::vcovCR}.
\item Bootstrap: \code{"vcovBS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"}, \code{"webb"}.
See \code{?sandwich::vcovBS}.
\item Other \code{sandwich} package functions: \code{"vcovHAC"}, \code{"vcovPC"}, \code{"vcovCL"}, \code{"vcovPL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the \strong{sandwich}
or \strong{clubSandwich} packages. Please refer to their documentation (e.g.,
\code{?sandwich::vcovHAC}) to see the list of available arguments.}

\item{verbose}{Toggle warnings and messages.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{adjust}{Character value naming the method used to adjust p-values or
confidence intervals. See \code{?emmeans::summary.emmGrid} for details.}
}
\value{
A data frame with at least two columns: the parameter names and the
p-values. Depending on the model, may also include columns for model
components etc.
}
\description{
This function attempts to return, or compute, p-values of a model's
parameters. See the documentation for your object's class:
\itemize{
\item \link[=p_value.BFBayesFactor]{Bayesian models} (\strong{rstanarm}, \strong{brms}, \strong{MCMCglmm}, ...)
\item \link[=p_value.zeroinfl]{Zero-inflated models} (\code{hurdle}, \code{zeroinfl}, \code{zerocount}, ...)
\item \link[=p_value.poissonmfx]{Marginal effects models} (\strong{mfx})
\item \link[=p_value.DirichletRegModel]{Models with special components} (\code{DirichletRegModel}, \code{clm2}, \code{cgam}, ...)
}
}
\section{Confidence intervals and approximation of degrees of freedom}{

There are different ways of approximating the degrees of freedom depending
on different assumptions about the nature of the model and its sampling
distribution. The \code{ci_method} argument modulates the method for computing degrees
of freedom (df) that are used to calculate confidence intervals (CI) and the
related p-values. Following options are allowed, depending on the model
class:

\strong{Classical methods:}

Classical inference is generally based on the \strong{Wald method}.
The Wald approach to inference computes a test statistic by dividing the
parameter estimate by its standard error (Coefficient / SE),
then comparing this statistic against a t- or normal distribution.
This approach can be used to compute CIs and p-values.

\code{"wald"}:
\itemize{
\item Applies to \emph{non-Bayesian models}. For \emph{linear models}, CIs
computed using the Wald method (SE and a \emph{t-distribution with residual df});
p-values computed using the Wald method with a \emph{t-distribution with residual df}.
For other models, CIs computed using the Wald method (SE and a \emph{normal distribution});
p-values computed using the Wald method with a \emph{normal distribution}.
}

\code{"normal"}
\itemize{
\item Applies to \emph{non-Bayesian models}. Compute Wald CIs and p-values,
but always use a normal distribution.
}

\code{"residual"}
\itemize{
\item Applies to \emph{non-Bayesian models}. Compute Wald CIs and p-values,
but always use a \emph{t-distribution with residual df} when possible. If the
residual df for a model cannot be determined, a normal distribution is
used instead.
}

\strong{Methods for mixed models:}

Compared to fixed effects (or single-level) models, determining appropriate
df for Wald-based inference in mixed models is more difficult.
See \href{https://bbolker.github.io/mixedmodels-misc/glmmFAQ.html#what-are-the-p-values-listed-by-summaryglmerfit-etc.-are-they-reliable}{the R GLMM FAQ}
for a discussion.

Several approximate methods for computing df are available, but you should
also consider instead using profile likelihood (\code{"profile"}) or bootstrap ("\verb{boot"})
CIs and p-values instead.

\code{"satterthwaite"}
\itemize{
\item Applies to \emph{linear mixed models}. CIs computed using the
Wald method (SE and a \emph{t-distribution with Satterthwaite df}); p-values
computed using the Wald method with a \emph{t-distribution with Satterthwaite df}.
}

\code{"kenward"}
\itemize{
\item Applies to \emph{linear mixed models}. CIs computed using the Wald
method (\emph{Kenward-Roger SE} and a \emph{t-distribution with Kenward-Roger df});
p-values computed using the Wald method with \emph{Kenward-Roger SE and t-distribution with Kenward-Roger df}.
}

\code{"ml1"}
\itemize{
\item Applies to \emph{linear mixed models}. CIs computed using the Wald
method (SE and a \emph{t-distribution with m-l-1 approximated df}); p-values
computed using the Wald method with a \emph{t-distribution with m-l-1 approximated df}.
See \code{\link[=ci_ml1]{ci_ml1()}}.
}

\code{"betwithin"}
\itemize{
\item Applies to \emph{linear mixed models} and \emph{generalized linear mixed models}.
CIs computed using the Wald method (SE and a \emph{t-distribution with between-within df});
p-values computed using the Wald method with a \emph{t-distribution with between-within df}.
See \code{\link[=ci_betwithin]{ci_betwithin()}}.
}

\strong{Likelihood-based methods:}

Likelihood-based inference is based on comparing the likelihood for the
maximum-likelihood estimate to the the likelihood for models with one or more
parameter values changed (e.g., set to zero or a range of alternative values).
Likelihood ratios for the maximum-likelihood and alternative models are compared
to a \eqn{\chi}-squared distribution to compute CIs and p-values.

\code{"profile"}
\itemize{
\item Applies to \emph{non-Bayesian models} of class \code{glm}, \code{polr}, \code{merMod} or \code{glmmTMB}.
CIs computed by \emph{profiling the likelihood curve for a parameter}, using
linear interpolation to find where likelihood ratio equals a critical value;
p-values computed using the Wald method with a \emph{normal-distribution} (note:
this might change in a future update!)
}

\code{"uniroot"}
\itemize{
\item Applies to \emph{non-Bayesian models} of class \code{glmmTMB}. CIs
computed by \emph{profiling the likelihood curve for a parameter}, using root
finding to find where likelihood ratio equals a critical value; p-values
computed using the Wald method with a \emph{normal-distribution} (note: this
might change in a future update!)
}

\strong{Methods for bootstrapped or Bayesian models:}

Bootstrap-based inference is based on \strong{resampling} and refitting the model
to the resampled datasets. The distribution of parameter estimates across
resampled datasets is used to approximate the parameter's sampling
distribution. Depending on the type of model, several different methods for
bootstrapping and constructing CIs and p-values from the bootstrap
distribution are available.

For Bayesian models, inference is based on drawing samples from the model
posterior distribution.

\code{"quantile"} (or \code{"eti"})
\itemize{
\item Applies to \emph{all models (including Bayesian models)}.
For non-Bayesian models, only applies if \code{bootstrap = TRUE}. CIs computed
as \emph{equal tailed intervals} using the quantiles of the bootstrap or
posterior samples; p-values are based on the \emph{probability of direction}.
See \code{\link[bayestestR:eti]{bayestestR::eti()}}.
}

\code{"hdi"}
\itemize{
\item Applies to \emph{all models (including Bayesian models)}. For non-Bayesian
models, only applies if \code{bootstrap = TRUE}. CIs computed as \emph{highest density intervals}
for the bootstrap or posterior samples; p-values are based on the \emph{probability of direction}.
See \code{\link[bayestestR:hdi]{bayestestR::hdi()}}.
}

\code{"bci"} (or \code{"bcai"})
\itemize{
\item Applies to \emph{all models (including Bayesian models)}.
For non-Bayesian models, only applies if \code{bootstrap = TRUE}. CIs computed
as \emph{bias corrected and accelerated intervals} for the bootstrap or
posterior samples; p-values are based on the \emph{probability of direction}.
See \code{\link[bayestestR:bci]{bayestestR::bci()}}.
}

\code{"si"}
\itemize{
\item Applies to \emph{Bayesian models} with proper priors. CIs computed as
\emph{support intervals} comparing the posterior samples against the prior samples;
p-values are based on the \emph{probability of direction}. See \code{\link[bayestestR:si]{bayestestR::si()}}.
}

\code{"boot"}
\itemize{
\item Applies to \emph{non-Bayesian models} of class \code{merMod}. CIs computed
using \emph{parametric bootstrapping} (simulating data from the fitted model);
p-values computed using the Wald method with a \emph{normal-distribution)}
(note: this might change in a future update!).
}

For all iteration-based methods other than \code{"boot"}
(\code{"hdi"}, \code{"quantile"}, \code{"ci"}, \code{"eti"}, \code{"si"}, \code{"bci"}, \code{"bcai"}),
p-values are based on the probability of direction (\code{\link[bayestestR:p_direction]{bayestestR::p_direction()}}),
which is converted into a p-value using \code{\link[bayestestR:pd_to_p]{bayestestR::pd_to_p()}}.
}

\examples{
data(iris)
model <- lm(Petal.Length ~ Sepal.Length + Species, data = iris)
p_value(model)
}
