% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_designs.R
\name{panel-designs}
\alias{panel-designs}
\alias{runif_panel_design}
\title{#' Create design matrix for panelPomp calculations}
\usage{
runif_panel_design(
  lower = numeric(0),
  upper = numeric(0),
  nseq,
  specific_names,
  unit_names
)
}
\arguments{
\item{lower, upper}{named numeric vectors giving the lower and upper bounds
of the ranges, respectively.}

\item{nseq}{Total number of points requested}

\item{specific_names}{Character vector containing the names of unit-specific
parameters. This argument must be used in conjunction with the argument
\code{unit_names}; it is used if the search bounds for all unspecified
unit-specific parameters are the same.}

\item{unit_names}{Character vector containing the names of the units of the
panel. If not used in conjunction with \code{unit_names} this argument
is ignored.}
}
\value{
\code{runif_panel_design} returns a \code{data.frame} object with
\code{nseq} rows. Each row corresponds to a parameter set drawn randomly
from a multivariate uniform distribution specified by the \code{lower},
\code{upper}, \code{specific_names} and \code{unit_names} arguments.
}
\description{
These functions are useful for generating design matrices for the exploration
of parameter space.
}
\examples{
runif_panel_design(
  lower = c('a' = 0, 'b' = 10, 'a[u2]' = 0.5),
  upper = c('a' = 1, 'b' = 15, 'a[u2]' = 0.75),
  specific_names = c('a'),
  unit_names = paste0(rep('u', 5), 1:5),
  nseq = 10
)
}
\author{
Jesse Wheeler, Aaron A. King
}
\concept{panel-designs}
