% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2b_parameter_estimation_survival_functions.R
\name{use_km_survival}
\alias{use_km_survival}
\title{###########################################################################
Get the parameter values using the Kaplan-Meier survival analysis}
\usage{
use_km_survival(
  param_to_be_estimated,
  dataset,
  indep_var,
  covariates,
  timevar_survival
)
}
\arguments{
\item{param_to_be_estimated}{parameter of interest}

\item{dataset}{data set to be provided}

\item{indep_var}{the independent variable (column name in data file)}

\item{covariates}{list of covariates}

\item{timevar_survival}{time variable for survival analysis, default is NA}
}
\value{
the results of the regression analysis, fit results, summary and plot
}
\description{
###########################################################################
Get the parameter values using the Kaplan-Meier survival analysis
}
\details{
This function is for survival analysis using Kaplan Meier.
This plots the cumulative survival function for each combination of covariate
If the covariate is numeric, R takes it as different levels.
The plot uses the returned list of survfit and extracts the time
and the strata from summary of the fit (implemented in
plot_return_survival_curve function)
}
\examples{
\donttest{
data_for_survival <- survival::aml
surv_estimated <- use_km_survival("status", data_for_survival, "x",
  covariates = NA, "time")
  }
\donttest{
data_for_survival <- survival::lung
surv_estimated <- use_km_survival("status", data_for_survival, "sex",
  covariates = c("ph.ecog"), "time")
}
}
