% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_model_functions.R
\name{assign_parameters}
\alias{assign_parameters}
\title{Function to assign the values of nested parameters from the parameter list}
\usage{
assign_parameters(param_list)
}
\arguments{
\item{param_list}{list of parameters, can be nested,
or can be used the list returned from define_parameters()}
}
\value{
list of assigned parameters
}
\description{
Function to assign the values of nested parameters from the parameter list
}
\details{
The parameter list should be a list of parameters in the form
name value pairs. If the name value pairs is given as a string it throws
error as in assign_parameters(c("cost_A = 100", "a = 10")) even if you
use assign_parameters(define_parameters(c("cost_A = 100","a = 10")))
but this will be ok if you use the below forms
assign_list2 <- c(a = 10, cost_A = "a + 100", cost_B = 10)
assign_parameters(assign_list2) OR
param_list <- define_parameters(a = 10, cost_A = "a + 100", cost_B = 10)
assign_list <- assign_parameters(param_list)
Also for nested parameters, remember to give the parameters in order so
that at run time, the parameters can be evaluated
for example, assign_list = define_parameters(cost_A="a+100", a=10)
assign_parameters(assign_list) will throw an error, while
assign_list = define_parameters( a = 10, cost_A = "a + 100")
assign_parameters(assign_list) will successfully assign parameters
as the parameters 'a' is visible before the calculation of 'cost_A'
Another thing to note is that while using define_parameters, just enumerate
them, no need to create as a list by using c() or list function
}
\examples{
param_list <- define_parameters(
  cost_direct_med_A = 1701, cost_comm_care_A = 1055,
  cost_direct_med_B = 1774, cost_comm_care_B = 1278,
  cost_direct_med_C = 6948,
  cost_comm_care_C = 2059, cost_zido = 2456, cost_health_A =
  "cost_direct_med_A + cost_comm_care_A",
  cost_health_B = "cost_direct_med_B + cost_comm_care_B",
  cost_health_C = "cost_direct_med_C + cost_comm_care_C",
  cost_drug = "cost_zido"
)
assign_parameters(param_list)
}
