% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owid_get.R
\name{owid_get}
\alias{owid_get}
\title{Download data from Our World in Data}
\usage{
owid_get(
  chart_id = NULL,
  entities = NULL,
  start_date = NULL,
  end_date = NULL,
  url = NULL,
  use_column_short_names = TRUE,
  snake_case = TRUE
)
}
\arguments{
\item{chart_id}{Character string specifying the chart identifier
(e.g., "life-expectancy"). Not required if \code{url} is provided.}

\item{entities}{Vector of entity codes (e.g., c("USA", "DEU")).
If NULL, data for all available entities is returned.}

\item{start_date}{Start date for filtering data. Can be a date string or
a year. If NULL, starts from the earliest available data.}

\item{end_date}{End date for filtering data. Can be a date string or a year.
If NULL, ends with the latest available data.}

\item{url}{Direct URL to an OWID dataset. If provided, \code{chart_id} is ignored.}

\item{use_column_short_names}{Logical. If TRUE (default), uses short column
names.}

\item{snake_case}{Logical. If TRUE (default), converts column names to
lowercase.}
}
\value{
A tibble containing the requested OWID data.
}
\description{
Retrieves data from Our World in Data (OWID) by specifying a chart identifier
or direct URL. Allows filtering by entities and time periods.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Download a full table
owid_get("life-expectancy")

# Download a table only for selected entities
owid_get("life-expectancy", c("AUS", "AUT", "GER"))

# Download a table only for selected time periods
owid_get("life-expectancy", c("USA"), 1970, 1980)

# Download daily data for selected time periods
owid_get(
 "daily-covid-vaccination-doses-per-capita", "DEU",
 "2020-12-28", "2020-12-31"
)

# Download a table by just providing an URL (with or without .csv)
owid_get(
 url = paste0(
   "https://ourworldindata.org/grapher/civil-liberties-score-fh",
   "?tab=chart&time=earliest..2023&country=ARG~AUS~BWA~CHN~ALB~DEU"
 )
)
owid_get(
 url = paste0(
   "https://ourworldindata.org/grapher/civil-liberties-score-fh.csv",
   "?tab=chart&time=earliest..2023"
 )
)
}
\dontshow{\}) # examplesIf}
}
