% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.ordinalbayes}
\alias{coef.ordinalbayes}
\title{Extract Model Coefficients}
\usage{
\method{coef}{ordinalbayes}(object, method = mean, ...)
}
\arguments{
\item{object}{an \code{ordinalbayes} object.}

\item{method}{The default is \code{method=mean} which estimates the mean of each parameter in the MCMC chain. Other options are \code{method=median} or any other relevant summary function.}

\item{...}{other arguements.}
}
\value{
\item{alpha }{Summary estimates for the thresholds}

\item{zeta }{Summary estimates for the unpenalized covariates. Only available if unpenalized covariates were included in the fitted model.}

\item{beta}{Summary estimates for the penalized covariates}

\item{gamma}{Summary estimates for the variable inclusion indicators. Not available when \code{model="lasso"}}
}
\description{
Extract Model Coefficients
}
\examples{
\donttest{
library(DESeq2)
data(reducedSet)
fit<-ordinalbayes(Stage~1, data=colData(reducedSet),x=t(assay(reducedSet)),
         model="regressvi", gamma.ind="fixed", pi.fixed=0.99,
         adaptSteps=1000, burnInSteps=1000, nChains=2,
         numSavedSteps=2000, thinSteps=2, seed=26)
coef(fit)
}
}
\seealso{
\code{\link{ordinalbayes}}, \code{\link{print.ordinalbayes}}, \code{\link{summary.ordinalbayes}}, \code{\link{predict.ordinalbayes}}
}
\keyword{methods}
