% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_odf_tbl.R
\name{as_odf_tbl}
\alias{as_odf_tbl}
\title{Converts a data frame to odf_tbl}
\usage{
as_odf_tbl(x, active_language = "en", language_of_metadata = NA)
}
\arguments{
\item{x}{a data.frame that should be converted to an odf_tbl.
(\code{languages = "all"}).}

\item{active_language}{Select the language that should be the active metadata language.
Default is 'en', or the first language occurring.}

\item{language_of_metadata}{Language of metadata, where language tag is missing, which is metadata in
attributes label, description and labels. Default is NA.}
}
\value{
odf_tbl with attributes including dataset and variable
information.
}
\description{
Converts a data.frame (or any subclass) object to an odf_tbl
(Open Data Format tibble).
}
\examples{
# Create a dataframe with 4 variables id, name, age, and diagnosis
exampledata <- data.frame(id = 1:5,
                          name = c("Klaus", "Anna", "Rebecca",
                                   "Kevin", "Janina"),
                          age = c(55, 40, 19, 25, 60), 
                          diagnosis = c(1,3,3,2,1))
# Add metadata for dataset
attr(exampledata, "name") <- "patientdata"
attr(exampledata, "label_en") <- "Patient Data"
attr(exampledata, "description_en") <- "Patient database of the practice Dr. Sommer"
attr(exampledata, "url") <- "www.example.url.en"

# Add metadata for diagnosis variable with label, description and value labels.
attr(exampledata$id, "name") <- "id"
attr(exampledata$id, "label_en") <- "Patiend ID"
attr(exampledata$id, "description_en") <- "Practice Patiend ID"
attr(exampledata$diagnosis, "name") <- "diagnose"
attr(exampledata$diagnosis, "label_en") <- "Diagnosis"
attr(exampledata$diagnosis, "description_en") <- "Diagnosis patient last visit"
valuelabels_diagnosis <- 1:4
names(valuelabels_diagnosis) <- c("Covid", "Influenza", "Common cold", "Tonsillitis")
attr(exampledata$diagnosis, "labels_en") <- valuelabels_diagnosis
# use as_odf_tbl() to transform dataframe to odf_tibble
example_odf  <-  as_odf_tbl(exampledata)

# Display metadata using docu_odf
docu_odf(example_odf, style = "print")

# Display metadata of diagnosis Variable
docu_odf(example_odf$diagnosis, style = "print")


}
