% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cholesky_root.R
\name{cov_to_chol}
\alias{cov_to_chol}
\alias{chol_to_cov}
\alias{unique_chol}
\title{Cholesky root of covariance matrix}
\usage{
cov_to_chol(cov, unique = TRUE)

chol_to_cov(chol)

unique_chol(chol)
}
\arguments{
\item{cov}{[\code{matrix()}]\cr
A covariance matrix.

It can also be the zero matrix, in which case the Cholesky root is defined as
the zero matrix.}

\item{unique}{[\code{logical(1)}]\cr
Ensure that the Cholesky decomposition is unique by restricting the diagonal
elements to be positive?}

\item{chol}{[\code{numeric()}]\cr
Cholesky root elements.}
}
\value{
For \code{\link{cov_to_chol}} a \code{numeric} \code{vector} of Cholesky root
elements.

For \code{\link{chol_to_cov}} a covariance \code{matrix}.
}
\description{
These functions compute the Cholesky root elements of a covariance matrix
and, conversely, build a covariance matrix from its Cholesky root elements.
}
\examples{
cov <- sample_covariance_matrix(4)
chol <- cov_to_chol(cov)
all.equal(cov, chol_to_cov(chol))
}
\seealso{
Other matrix helpers: 
\code{\link{check_correlation_matrix}()},
\code{\link{check_covariance_matrix}()},
\code{\link{check_transition_probability_matrix}()},
\code{\link{diff_cov}()},
\code{\link{insert_matrix_column}()},
\code{\link{matrix_diagonal_indices}()},
\code{\link{matrix_indices}()},
\code{\link{sample_correlation_matrix}()},
\code{\link{sample_covariance_matrix}()},
\code{\link{sample_transition_probability_matrix}()},
\code{\link{stationary_distribution}()}
}
\concept{matrix helpers}
\keyword{transformation}
