% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_normal_explicit.R
\name{sim_normal_explicit}
\alias{sim_normal_explicit}
\title{simulate a sequence assuming substitutions are only accumulated along the
branches, using the explicit simulation method (e.g. reverse substitutions
are modeled explicitly)}
\usage{
sim_normal_explicit(x, l = 1000, Q = NULL, bf = NULL, rootseq = NULL, rate = 1)
}
\arguments{
\item{x}{a phylogenetic tree \code{tree}, i.e. an object of class
\code{phylo} or and object of class \code{pml}.}

\item{l}{length of the sequence to simulate.}

\item{Q}{the rate matrix.}

\item{bf}{base frequencies.}

\item{rootseq}{a vector of length l containing the root sequence, other root
sequence is randomly generated.}

\item{rate}{mutation rate or scaler for the edge length, a numerical value
greater than zero.}
}
\value{
list with four items \enumerate{
\item{alignment} Phydat object with the resulting alignment
\item{rootseq} the rootsequence used
\item{total_branch_substitutions} total number of substitutions accumulated
on the branches
\item{total_node_substitutions} total number of substitutions accumulated at
the nodes}
}
\description{
simulate a sequence assuming substitutions are only accumulated along the
branches, using the explicit simulation method (e.g. reverse substitutions
are modeled explicitly)
}
