% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_poly.R
\name{eval_poly}
\alias{eval_poly}
\title{Polynomial evaluation}
\usage{
eval_poly(poly, newdata)
}
\arguments{
\item{poly}{List containing 2 items: \code{labels} and \code{values}.
\itemize{
\item \code{labels}: List of integer vectors with same length (or number of cols)
as \code{values}, where each integer vector denotes the combination of
variables associated to the coefficient value stored at the same position in
\code{values}. That is, the monomials in the polynomial. Note that the
variables are numbered from 1 to p, with the intercept is represented by 0.
\item \code{values}: Matrix (can also be a vector if single polynomial), where
each column represents a polynomial, with same number of rows as the length
of \code{labels}, containing at each row the value of the coefficient
of the monomial given by the equivalent label in that same position.
}

Example: If \code{labels} contains the integer vector c(1,1,3) at position
5, then the value stored in \code{values} at row 5 is the coefficient
associated with the term x_1^2*x_3.}

\item{newdata}{Input data as matrix, vector or dataframe.
Number of columns (or elements in vector) should be the number of variables
in the polynomial (dimension p). Response variable to be predicted should
not be included.}
}
\value{
Returns a matrix containing the evaluation of the polynomials.
Each column corresponds to each polynomial used and each row to each
observation, meaning that each column vector corresponds to the results of
evaluating all the given data for each polynomial.
}
\description{
Evaluates one or several polynomials on the given data.
}
\details{
Note that this function is unstable and subject to change. Therefore it is
not exported but this documentations is left available so users can use it if
needed to simulate data by using \code{nn2poly:::eval_poly()}
}
\seealso{
\code{eval_poly()} is also used in \code{\link[=predict.nn2poly]{predict.nn2poly()}}.
}
