% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche_ellipse.R
\name{niche_ellipse}
\alias{niche_ellipse}
\title{Create ellipses based on Bayesian estimates of \eqn{\mu} and \eqn{\Sigma}}
\usage{
niche_ellipse(
  dat_mu,
  dat_sigma,
  isotope_a = NULL,
  isotope_b = NULL,
  p_ell = NULL,
  random = NULL,
  set_seed = NULL,
  n = NULL,
  message = TRUE
)
}
\arguments{
\item{dat_mu}{a \code{data.frame} containing \eqn{\mu} Bayesian estimates.
This \code{data.frame} needs to be in long format with each \eqn{\mu}
estimate for each isotope stacked on top of each other. This can be produced
using \code{extract_mu()}.}

\item{dat_sigma}{a \code{data.frame} containing \eqn{\Sigma} Bayesian estimates.
This \code{data.frame} needs be in wide format, that is \eqn{\Sigma} (covariance)
matrices stacked on top of each other. See example of how to convert to
wide format. This can be produced using \code{extract_sigma()}.}

\item{isotope_a}{character string that is the column name of the first
isotope used in \code{dat_sigma}. Defaults to \code{"d13c"}.}

\item{isotope_b}{character string that is the column name of the second
isotope used in \code{dat_sigma}. Defaults to \code{"d15n"}.}

\item{p_ell}{is the confidence interval of each ellipse estimate.
Default is 0.95 (i.e., 95\% confidence interval).
This value is bound by 0 and 1 and has to be a \code{numeric}.}

\item{random}{logical value indicating whether or not to randomly sample
posterior distributions for \eqn{\mu} and \eqn{\Sigma} to create a sub-sample
of ellipse. Default is \code{TRUE}.}

\item{set_seed}{numerical value to set seed for random sampling. Default is
a random value. To consistently sample the same subsample, please supply
a numerical value (e.g., \code{4}). It is highly suggested to use set_seed to make
the function results when randomly sampling reproducible.}

\item{n}{numerical value that controls the number of random samples.
Default is \code{10}.}

\item{message}{control whether the time processing is displayed after the
end of the function. Default is \code{TRUE}.}
}
\value{
A \code{tibble} containing, \code{sample_name}, \code{sample_number}, and the
isotopes that were used in the estimation of ellipse
(i.e.,  and \code{d13c} and \code{d15n}).
}
\description{
This function allows the user to supply Bayesian estimates of \eqn{\mu} and
\eqn{\Sigma} to create estimated Bayesian ellipse for niche region.
}
\examples{
niche_ellipse(dat_mu = mu_est_long,
              dat_sigma = sigma_est_wide)
}
\seealso{
\code{\link[nicheROVER:niw.post]{nicheROVER::niw.post()}}, \code{\link[SIBER:siberMVN]{SIBER::siberMVN()}}, \code{\link[=extract_mu]{extract_mu()}},
and \code{\link[=extract_sigma]{extract_sigma()}}
}
