% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_nhdplus.R
\name{subset_vpu}
\alias{subset_vpu}
\title{Subset by Vector Processing Unit}
\usage{
subset_vpu(fline, vpu, include_null_rpuid = TRUE, run_make_standalone = TRUE)
}
\arguments{
\item{fline}{sf data.frame NHD Flowlines with comid, pathlength, lengthkm,
hydroseq, levelpathi, rpuid, vpuid, and arbolatesu
(dnhydroseq is required if tocomid is not provided).}

\item{vpu}{character e.g. "01"}

\item{include_null_rpuid}{logical default TRUE. Note that there are some
flowlines that may have a NULL rpuid but be included in the vector
processing unit.}

\item{run_make_standalone}{logical default TRUE
should the run_make_standalone function be run on result?}
}
\value{
data.frame containing subset network
}
\description{
Calls \link{subset_rpu} for all raster processing units for the
requested vector processing unit.
}
\examples{

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

sample_flines <- sf::read_sf(sample_data, "NHDFlowline_Network")

subset_vpu(sample_flines, "07")

}
