% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkFun.R
\name{sem.net}
\alias{sem.net}
\title{Fit a Structural Equation Model (SEM) with both network and non-network data by incorporating node-level network statistics as variables.}
\usage{
sem.net(
  model = NULL,
  data = NULL,
  netstats = NULL,
  ordered = NULL,
  sampling.weights = NULL,
  data.rescale = FALSE,
  netstats.rescale = FALSE,
  group = NULL,
  cluster = NULL,
  constraints = "",
  WLS.V = NULL,
  NACOV = NULL,
  netstats.options = NULL,
  ...
)
}
\arguments{
\item{model}{A model string specified in lavaan model syntax that includes relationships among the network and non-network variables.}

\item{data}{A list containing the data. The list has two named components, "network" and "nonnetwork"; "network" is a list of named adjacency matrices for the network data, and "nonnetwork" is the dataframe of non-network covariates.}

\item{netstats}{A user-specified list of network statistics to be calculated and used in the SEM. Available options include "degree", "betweenness", "closeness", "evcent", "stresscent", and "infocent" from the "sna" package and "ivi", "hubness.score", "spreading.score" and "clusterRank" from the "influential" package.}

\item{ordered}{Parameter same as "ordered" in the lavaan sem() function; whether to treat data as ordinal.}

\item{sampling.weights}{Parameter same as "sampling.weights" in the lavaan sem() function; whether to apply weights to data.}

\item{data.rescale}{TRUE or FALSE, whether to rescale the whole dataset (with restructured network and nonnetwork data) to have mean 0 and standard deviation 1 when fitting it to SEM, default to FALSE.}

\item{netstats.rescale}{TRUE or FALSE, whether to rescale the network statistics to have mean 0 and standard deviation 1, default to FALSE.}

\item{group}{Parameter same as "group" in the lavaan sem() function; whether to fit a multigroup model.}

\item{cluster}{Parameter same as "cluster" in the lavaan sem() function; whether to fit a cluster model.}

\item{constraints}{Parameter same as "constraints" in the lavaan sem() function; whether to apply constraints to the model.}

\item{WLS.V}{Parameter same as "WLS.V" in the lavaan sem() function; whether to use WLS.V estimator.}

\item{NACOV}{Parameter same as "NACOV" in the lavaan sem() function; whether to use NACOV estimator.}

\item{netstats.options}{A user-specified named list with element names corresponding to the network statistics names and element values corresponding to options for that network statistics used as optional arguments in the corresponding functions in the "sna" or "influential" packages. e.g., netstats.options=list("degree"=list("cmode"="freeman"), "closeness"=list("cmode"="undirected"), "clusterRank"=list("directed"=FALSE)).}

\item{...}{Optional arguments for the sem() function.}
}
\value{
A networksem object containing the updated model specification string with the reconstructed network statistics as variables and a lavaan SEM object.
}
\description{
Fit a Structural Equation Model (SEM) with both network and non-network data by incorporating node-level network statistics as variables.
}
\examples{
set.seed(100)
nsamp = 20
net <- ifelse(matrix(rnorm(nsamp^2), nsamp, nsamp) > 1, 1, 0)
mean(net) # density of simulated network
lv1 <- rnorm(nsamp)
lv2 <- rnorm(nsamp)
nonnet <- data.frame(x1 = lv1*0.5 + rnorm(nsamp),
                     x2 = lv1*0.8 + rnorm(nsamp),
                     x3 = lv2*0.5 + rnorm(nsamp),
                     x4 = lv2*0.8 + rnorm(nsamp))

model <-'
  lv1 =~ x1 + x2
  lv2 =~ x3 + x4
 net ~ lv2
  lv1 ~ net + lv2
'
data = list(network = list(net = net), nonnetwork = nonnet)
set.seed(100)
res <- sem.net(model = model, data = data, netstats = c('degree'))
summary(res)
}
