% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nca.check.sim.R
\name{nca.check.sim}
\alias{nca.check.sim}
\title{Check simulated data}
\usage{
nca.check.sim(simData, idNmSim = "ID", timeNmSim = "TIME",
  concNmSim = "DV", filterNm = NULL, filterExcl = NULL,
  str1Nm = NULL, str1 = NULL, str2Nm = NULL, str2 = NULL,
  str3Nm = NULL, str3 = NULL, adminType = "extravascular",
  TI = NULL, doseAmtNm = NULL, blqNm = NULL, blqExcl = 1,
  evid = TRUE, evidIncl = 0, mdv = FALSE)
}
\arguments{
\item{simData}{Simulated concentration-time data.}

\item{idNmSim}{Column name for ID in simulated data. Default is \strong{"ID"}}

\item{timeNmSim}{Column name for time in simulated data. Default is 
\strong{"TIME"}}

\item{concNmSim}{Column name for concentration in simulated data. Default is 
\strong{"DV"}}

\item{filterNm}{Column name to filter data. Default is \strong{\code{NULL}}}

\item{filterExcl}{Row exclusion criteria based on the column defined by
\code{filterNm}. This can be numeric value or logical condition (e.g. c(1,
2, "<20", ">=100", "!=100")). Default is \strong{\code{NULL}}}

\item{str1Nm}{Column name for 1st level population stratifier. Default is
\strong{\code{NULL}}}

\item{str1}{Stratification ID of the members within 1st level stratification
(e.g c(1,2)). Default is \strong{\code{NULL}}}

\item{str2Nm}{Column name for 2nd level population stratifier. Default is
\strong{\code{NULL}}}

\item{str2}{Stratification ID of the members within 2nd level stratification
(e.g c(1,2)). Default is \strong{\code{NULL}}}

\item{str3Nm}{Column name for 3rd level population stratifier. Default is
\strong{\code{NULL}}}

\item{str3}{Stratification ID of the members within 3rd level stratification
(e.g c(1,2)). Default is \strong{\code{NULL}}}

\item{adminType}{Route of administration. Allowed options are iv-bolus,
iv-infusion or extravascular. Default is \strong{"extravascular"}}

\item{TI}{Infusion duration. If TI is a single numeric value, TI is the same
for all individuals. If TI is the name of a column with numeric data
present in the data set, TI is set to the unique value of the column for a
given individual. Default is \strong{\code{NULL}}}

\item{doseAmtNm}{Column name to specify dose amount. Default is
\strong{\code{NULL}}}

\item{blqNm}{Name of BLQ column if used to exclude data. Default is
\strong{\code{NULL}}}

\item{blqExcl}{Excluded BLQ value; either a numeric value or a logical
condition (e.g. 1 or ">=1" or c(1,">3")). Used only if the \code{blqNm} is
not \code{NULL}. Default is \strong{"1"}}

\item{evid}{If \code{TRUE} EVID is used to filter data. Default is
\strong{\code{TRUE}}}

\item{evidIncl}{Included values in EVID. Default is \strong{"0"}}

\item{mdv}{If \code{TRUE} MDV is used to include data when MDV=0. Default is
\strong{\code{FALSE}}}
}
\value{
A list of objects
}
\description{
\pkg{nca.check.sim} Checks simulated data for compatibility with ncappc and 
processes the data with various filtering criteria.
}
\details{
\pkg{nca.check.sim} Checks simulated data for compatibility with ncappc.
}
