% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{mc_reshape_long}
\alias{mc_reshape_long}
\title{Export values to long table}
\usage{
mc_reshape_long(data, localities = NULL, sensors = NULL, use_utc = TRUE)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{localities}{names of localities; if NULL then all (default NULL)}

\item{sensors}{names of sensors; if NULL then all (default NULL) see \code{names(mc_data_sensors)}}

\item{use_utc}{if FALSE, then the time shift from \code{tz_offset} metadata is used to correct
(shift) the output time-series (default TRUE)

In the Agg-format myClim object \code{use_utc = FALSE} is allowed only for steps shorter than one day. In myClim
the day nd longer time steps are defined by the midnight, but this represent whole day, week, month, year...
shifting daily, weekly, monthly... data (shift midnight) does not make sense in our opinion.
But when user need more flexibility, then myClim Raw-format
can be used, In Raw-format \code{use_utc} is not limited, user can shift an data without the restrictions.
See \link{myClim-package}}
}
\value{
data.frame

columns:
\itemize{
\item locality_id
\item serial_number
\item sensor_name
\item height
\item datetime
\item time_to
\item value
}
}
\description{
This function converts myClim object to long R data.frame.
}
\examples{
head(mc_reshape_long(mc_data_example_clean, c("A6W79", "A2E32"), c("TMS_T1", "TMS_T2")), 10)
}
