% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substitution-sub-margins.R
\name{sub}
\alias{sub}
\title{Simple Substitution}
\usage{
sub(
  object,
  delta,
  basesub,
  summary = TRUE,
  ref = "grandmean",
  level = "aggregate",
  weight = "equal",
  scale = c("response", "linear"),
  cores = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{\link{brmcoda}} object.}

\item{delta}{A integer, numeric value or vector indicating the amount of substituted change between compositional parts.}

\item{basesub}{A \code{data.frame} or \code{data.table} of the base possible substitution of compositional parts.
This data set can be computed using function \code{\link{basesub}}.
If \code{NULL}, all possible pairwise substitution of compositional parts are used.}

\item{summary}{A logical value.
Should the estimate at each level of the reference grid (\code{FALSE})
or their average (\code{TRUE}) be returned?
Default is \code{TRUE}.
Only applicable for model with covariates in addition to
the isometric log-ratio coordinates (i.e., adjusted model).}

\item{ref}{Either a character value or vector or a dataset.
Can be \code{"grandmean"} and/or \code{"clustermean"}, or
a \code{data.frame} or \code{data.table} of user's specified reference grid consisting
of combinations of covariates over which predictions are made.
User's specified reference grid is only possible for simple substitution.
Single level models are default to \code{"grandmean"}.}

\item{level}{A character string or vector.
Should the estimate of multilevel models focus on the \code{"between"} and/or \code{"within"} or \code{"aggregate"} variance?
Single-level models are default to \code{"aggregate"}.}

\item{weight}{A character value specifying the weight to use in calculation of the reference composition.
If \code{"equal"}, give equal weight to units (e.g., individuals).
If \code{"proportional"}, weights in proportion to the frequencies of units being averaged
(e.g., observations across individuals).
Default to \code{"equal"} for \code{ref = "grandmean"} and \code{"proportional"} for \code{ref = "clustermean"}.}

\item{scale}{Either \code{"response"} or \code{"linear"}.
If \code{"response"}, results are returned on the scale of the response variable.
If \code{"linear"}, results are returned on the scale of the linear predictor term,
that is without applying the inverse link function or other transformations.}

\item{cores}{Number of cores to use when executing the chains in parallel,
we recommend setting the \code{mc.cores} option
to be as many processors as the hardware and RAM allow (up to the number of compositional parts).
For non-Windows OS in non-interactive R sessions, forking is used instead of PSOCK clusters.}

\item{...}{currently ignored.}
}
\value{
A list containing the results of multilevel compositional substitution model.
The first six lists contain the results of the substitution estimation for a compositional part.
\item{\code{Mean}}{ Posterior means.}
\item{\code{CI_low} and \code{CI_high}}{ 95\% credible intervals.}
\item{\code{Delta}}{ Amount substituted across compositional parts.}
\item{\code{From}}{ Compositional part that is substituted from.}
\item{\code{To}}{ Compositional parts that is substituted to.}
\item{\code{Level}}{ Level where changes in composition takes place.}
\item{\code{Reference}}{ Either \code{grandmean}, \code{clustermean}, or \code{users}.}
}
\description{
This function is an alias of \code{\link{substitution}} to estimates the the difference in an outcome
when compositional parts are substituted for specific unit(s)
using a aggregate reference composition
(e.g., compositional mean at sample level, not seperated by between- and within effects).
It is recommended that users run substitution model using the \code{\link{substitution}} function.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){

cilr <- complr(data = mcompd, sbp = sbp, 
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID", total = 1440)

# model with compositional predictor at between and within-person levels
m <- brmcoda(complr = cilr, 
             formula = Stress ~ ilr1 + ilr2 + ilr3 + ilr4 + (1 | ID), 
             chain = 1, iter = 500,
             backend = "cmdstanr")
             
subm <- sub(object = m, basesub = psub, delta = 5)
}}
}
\seealso{
\code{\link{substitution}}
}
