% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_mpm_set.R
\name{generate_mpm_set}
\alias{generate_mpm_set}
\title{Generate lists of Lefkovitch matrix population models (MPMs) based on life
history archetypes}
\usage{
generate_mpm_set(
  n = 10,
  n_stages = 3,
  archetype = 1,
  fecundity = 1.5,
  split = TRUE,
  by_type = TRUE,
  as_compadre = TRUE,
  max_surv = 0.99,
  constraint = NULL,
  attempts = 1000
)
}
\arguments{
\item{n}{The number of MPMs to generate. Default is 10.}

\item{n_stages}{The number of stages for the MPMs. Default is 3.}

\item{archetype}{The archetype of the MPMs. Default is 1.}

\item{fecundity}{A vector of fecundities for the MPMs. Default is 1.5.}

\item{split}{A logical indicating whether to split into submatrices. Default
is TRUE.}

\item{by_type}{A logical indicating whether the matrices should be returned
in a list by type (A, U, F, C). If split is \code{FALSE}, then \code{by_type} must
is coerced to be \code{FALSE}. Defaults to \code{TRUE}.}

\item{as_compadre}{A logical indicating whether the matrices should be
returned as a \code{CompadreDB} object. Default is \code{TRUE}. If \code{FALSE}, the
function returns a list.}

\item{max_surv}{The maximum acceptable survival value, calculated across all
transitions from a stage. Defaults to 0.99. This is only used if \code{split = TRUE}.}

\item{constraint}{An optional data frame with 4 columns named \code{fun}, \code{arg},
\code{lower} and \code{upper}. These columns specify (1) a function that outputs a
metric derived from an A matrix and (2) an argument for the function (\code{NA},
if no argument supplied) (3) the lower acceptable bound for the metric and
(4) upper acceptable bound for the metric. This could be used to specify}

\item{attempts}{An integer indicating the number of attempts To be made when
simulating matrix model. The default is 1000. If it takes more than 1000
attempts to make a matrix that satisfies the conditions set by the other
arguments, then a warning is produced.}
}
\value{
A list of MPMs that meet the specified criteria.
}
\description{
This function is deprecated. Use \code{rand_lefko_set} instead.
}
\details{
This function generates a list of \code{n} MPMs according to the specified
criteria. Criteria include the \code{archetype}, and the acceptable constraining
criteria, which could include lambda, generation time or any other metric
derived from an A matrix.
The function attempts to find matrices that fulfil the criteria, discarding
unacceptable matrices. By default, if it takes more than 1000 attempts to
find a suitable matrix model, then an error is produced. However, the number
of attempts can be altered with the \code{attempts} parameter.
}
\examples{
set.seed(42) # set seed for repeatability

# Basic operation, without splitting matrices and with no constraints
generate_mpm_set(
  n = 10, n_stages = 5, fecundity = c(0, 0, 4, 8, 10),
  archetype = 4, split = FALSE, by_type = FALSE, as_compadre = FALSE
)

# Constrain outputs to A matrices with lambda between 0.9 and 1.1
library(popbio)
constrain_df <- data.frame(
  fun = "lambda", arg = NA, lower = 0.9, upper =
    1.1
)
generate_mpm_set(
  n = 10, n_stages = 5, fecundity = c(0, 0, 4, 8, 10),
  archetype = 4, constraint = constrain_df, as_compadre = FALSE
)

# As above, but using popdemo::eigs function instead of popbio::lambda
# to illustrate use of argument
library(popdemo)
constrain_df <- data.frame(
  fun = "eigs", arg = "lambda", lower = 0.9, upper =
    1.1
)
generate_mpm_set(
  n = 10, n_stages = 5, fecundity = c(0, 0, 4, 8, 10),
  archetype = 4, constraint = constrain_df, as_compadre = FALSE
)

# Multiple constraints
# Constrain outputs to A matrices with lambda between 0.9 and 1.1, generation
# time between 3 and 5 and damping ratio between 1 and 7.
library(popbio)
constrain_df <- data.frame(
  fun = c("lambda", "generation.time", "damping.ratio"),
  arg = c(NA, NA, NA),
  lower = c(0.9, 3.0, 1.0),
  upper = c(1.1, 5.0, 7.0)
)
generate_mpm_set(
  n = 10, n_stages = 5, fecundity = c(0, 0, 4, 8, 10),
  archetype = 4, constraint = constrain_df, as_compadre = FALSE
)

}
\seealso{
\code{\link[=random_mpm]{random_mpm()}} which this function is essentially a wrapper for.

Other Lefkovitch matrices: 
\code{\link{rand_lefko_mpm}()},
\code{\link{rand_lefko_set}()},
\code{\link{random_mpm}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{Lefkovitch matrices}
