% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_track.R
\name{filter_track_data}
\alias{filter_track_data}
\alias{select_track_data}
\alias{mutate_track_data}
\alias{group_by_track_data}
\title{\code{dplyr} functions to manipulate the track data}
\usage{
filter_track_data(.data, ..., .track_id = NULL)

select_track_data(.data, ...)

mutate_track_data(.data, ...)

group_by_track_data(
  .data,
  ...,
  .add = FALSE,
  .drop = dplyr::group_by_drop_default(.data)
)
}
\arguments{
\item{.data}{the \code{move2} object}

\item{...}{The identifiers of one or more tracks to select or selection criteria based on track attributes}

\item{.track_id}{A vector of the ids of the tracks to select}

\item{.add}{see original function docs \code{\link[dplyr]{group_by}}}

\item{.drop}{see original function docs \code{\link[dplyr]{group_by}}}
}
\value{
a \code{move2} object
}
\description{
\itemize{
\item \code{filter_track_data} filter data based on a track attribute (e.g. select all juveniles).
Based on \code{\link[dplyr]{filter}}.
\item \code{select_track_data} keep or drop attributes in the track data. Based on \code{\link[dplyr]{select}}.
\item \code{mutate_track_data} create or modify attributes in the track data. Based on \code{\link[dplyr]{mutate}}.
\item \code{group_by_track_data} group by one or more attribute of the track data (e.g. group by sex, by taxon, by life stage,
etc). Based on \code{\link[dplyr]{group_by}}.
}
}
\examples{
## simulating a move2 object with 4 tracks
data <- mt_sim_brownian_motion(tracks = letters[1:4])

## retaining tracks "b" and "d"
data |>
  filter_track_data(.track_id = c("b", "d"))

## adding the attribute "sex" to the track data
data <- data |>
  mutate_track_data(sex = c("m", "f", "f", "m"))

## retaining tracks of females
data |> filter_track_data(sex == "f")

}
