% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning_spaces_rbv2.R
\name{mlr_tuning_spaces_rbv2}
\alias{mlr_tuning_spaces_rbv2}
\alias{mlr_tuning_spaces_classif.glmnet.rbv2}
\alias{mlr_tuning_spaces_classif.kknn.rbv2}
\alias{mlr_tuning_spaces_classif.ranger.rbv2}
\alias{mlr_tuning_spaces_classif.rpart.rbv2}
\alias{mlr_tuning_spaces_classif.svm.rbv2}
\alias{mlr_tuning_spaces_classif.xgboost.rbv2}
\alias{mlr_tuning_spaces_regr.glmnet.rbv2}
\alias{mlr_tuning_spaces_regr.kknn.rbv2}
\alias{mlr_tuning_spaces_regr.ranger.rbv2}
\alias{mlr_tuning_spaces_regr.rpart.rbv2}
\alias{mlr_tuning_spaces_regr.svm.rbv2}
\alias{mlr_tuning_spaces_regr.xgboost.rbv2}
\title{RandomBot V2 Tuning Spaces}
\source{
Binder M, Pfisterer F, Bischl B (2020).
\dQuote{Collecting Empirical Data About Hyperparameters for Data Driven AutoML.}
\url{https://www.automl.org/wp-content/uploads/2020/07/AutoML_2020_paper_63.pdf}.
}
\description{
Tuning spaces from the Binder (2020) article.
}
\section{glmnet tuning space}{

\itemize{
\item alpha \eqn{[0, 1]}{[0, 1]}
\item s \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
}
}

\section{kknn tuning space}{

\itemize{
\item k \eqn{[1, 30]}{[1, 30]}
}
}

\section{ranger tuning space}{

\itemize{
\item num.trees \eqn{[1, 2000]}{[1, 2000]}
\item replace [TRUE,FALSE]
\item sample.fraction \eqn{[0.1, 1]}{[0.1, 1]}
\item mtry.ratio \eqn{[0, 1]}{[0, 1]}
\item respect.unordered.factors [\dQuote{ignore}, \dQuote{order}, \dQuote{partition}]
\item min.node.size \eqn{[1, 100]}{[1, 100]}
\item splitrule [\dQuote{gini}, \dQuote{extratrees}]
\item num.random.splits \eqn{[1, 100]}{[1, 100]}
}

\code{mtry.power} is replaced by \code{mtry.ratio}.
}

\section{rpart tuning space}{

\itemize{
\item cp \eqn{[1e-04, 1]}{[1e-04, 1]} Logscale
\item maxdepth \eqn{[1, 30]}{[1, 30]}
\item minbucket \eqn{[1, 100]}{[1, 100]}
\item minsplit \eqn{[1, 100]}{[1, 100]}
}
}

\section{svm tuning space}{

\itemize{
\item kernel [\dQuote{linear}, \dQuote{polynomial}, \dQuote{radial}]
\item cost \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
\item gamma \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
\item tolerance \eqn{[1e-04, 2]}{[1e-04, 2]} Logscale
\item degree \eqn{[2, 5]}{[2, 5]}
}
}

\section{xgboost tuning space}{

\itemize{
\item booster [\dQuote{gblinear}, \dQuote{gbtree}, \dQuote{dart}]
\item nrounds \eqn{[7, 2981]}{[7, 2981]} Logscale
\item eta \eqn{[1e-04, 1]}{[1e-04, 1]} Logscale
\item gamma \eqn{[1e-05, 7]}{[1e-05, 7]} Logscale
\item lambda \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
\item alpha \eqn{[1e-04, 1000]}{[1e-04, 1000]} Logscale
\item subsample \eqn{[0.1, 1]}{[0.1, 1]}
\item max_depth \eqn{[1, 15]}{[1, 15]}
\item min_child_weight \eqn{[1, 100]}{[1, 100]} Logscale
\item colsample_bytree \eqn{[0.01, 1]}{[0.01, 1]}
\item colsample_bylevel \eqn{[0.01, 1]}{[0.01, 1]}
\item rate_drop \eqn{[0, 1]}{[0, 1]}
\item skip_drop \eqn{[0, 1]}{[0, 1]}
}
}

