% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuningInstanceSingleCrit.R
\name{TuningInstanceSingleCrit}
\alias{TuningInstanceSingleCrit}
\title{Single Criterion Tuning Instance for Batch Tuning}
\description{
\code{TuningInstanceSingleCrit} is a deprecated class that is now a wrapper around \link{TuningInstanceBatchSingleCrit}.
}
\section{Super classes}{
\code{\link[bbotk:OptimInstance]{bbotk::OptimInstance}} -> \code{\link[bbotk:OptimInstanceBatch]{bbotk::OptimInstanceBatch}} -> \code{\link[bbotk:OptimInstanceBatchSingleCrit]{bbotk::OptimInstanceBatchSingleCrit}} -> \code{\link[mlr3tuning:TuningInstanceBatchSingleCrit]{mlr3tuning::TuningInstanceBatchSingleCrit}} -> \code{TuningInstanceSingleCrit}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TuningInstanceSingleCrit-new}{\code{TuningInstanceSingleCrit$new()}}
\item \href{#method-TuningInstanceSingleCrit-clone}{\code{TuningInstanceSingleCrit$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="clear"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-clear'><code>bbotk::OptimInstance$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="format"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-format'><code>bbotk::OptimInstance$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="print"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-print'><code>bbotk::OptimInstance$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstanceBatch" data-id="eval_batch"><a href='../../bbotk/html/OptimInstanceBatch.html#method-OptimInstanceBatch-eval_batch'><code>bbotk::OptimInstanceBatch$eval_batch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstanceBatch" data-id="objective_function"><a href='../../bbotk/html/OptimInstanceBatch.html#method-OptimInstanceBatch-objective_function'><code>bbotk::OptimInstanceBatch$objective_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="TuningInstanceBatchSingleCrit" data-id="assign_result"><a href='../../mlr3tuning/html/TuningInstanceBatchSingleCrit.html#method-TuningInstanceBatchSingleCrit-assign_result'><code>mlr3tuning::TuningInstanceBatchSingleCrit$assign_result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningInstanceSingleCrit-new"></a>}}
\if{latex}{\out{\hypertarget{method-TuningInstanceSingleCrit-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningInstanceSingleCrit$new(
  task,
  learner,
  resampling,
  measure = NULL,
  terminator,
  search_space = NULL,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  check_values = FALSE,
  callbacks = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to tune.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling that is used to evaluate the performance of the hyperparameter configurations.
Uninstantiated resamplings are instantiated during construction so that all configurations are evaluated on the same data splits.
Already instantiated resamplings are kept unchanged.
Specialized \link{Tuner} change the resampling e.g. to evaluate a hyperparameter configuration on different data splits.
This field, however, always returns the resampling passed in construction.}

\item{\code{measure}}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Measure to optimize. If \code{NULL}, default measure is used.}

\item{\code{terminator}}{(\link[bbotk:Terminator]{bbotk::Terminator})\cr
Stop criterion of the tuning process.}

\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Hyperparameter search space. If \code{NULL} (default), the search space is
constructed from the \link[paradox:to_tune]{paradox::TuneToken} of the learner's parameter set
(learner$param_set).}

\item{\code{store_benchmark_result}}{(\code{logical(1)})\cr
If \code{TRUE} (default), store resample result of evaluated hyperparameter
configurations in archive as \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.}

\item{\code{store_models}}{(\code{logical(1)})\cr
If \code{TRUE}, fitted models are stored in the benchmark result
(\code{archive$benchmark_result}). If \code{store_benchmark_result = FALSE}, models
are only stored temporarily and not accessible after the tuning. This
combination is needed for measures that require a model.}

\item{\code{check_values}}{(\code{logical(1)})\cr
If \code{TRUE}, hyperparameter values are checked before evaluation and
performance scores after. If \code{FALSE} (default), values are unchecked but
computational overhead is reduced.}

\item{\code{callbacks}}{(list of \link[mlr3misc:Callback]{mlr3misc::Callback})\cr
List of callbacks.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TuningInstanceSingleCrit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TuningInstanceSingleCrit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TuningInstanceSingleCrit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
