% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerAsync.R
\name{TunerAsync}
\alias{TunerAsync}
\title{Class for Asynchronous Tuning Algorithms}
\description{
The \link{TunerAsync} implements the asynchronous optimization algorithm.
}
\details{
\link{TunerAsync} is an abstract base class that implements the base functionality each asynchronous tuner must provide.
}
\section{Resources}{

There are several sections about hyperparameter optimization in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
\itemize{
\item An overview of all tuners can be found on our \href{https://mlr-org.com/tuners.html}{website}.
\item Learn more about \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-tuner}{tuners}.
}

The \href{https://mlr-org.com/gallery-all-optimization.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Use the \href{https://mlr-org.com/gallery/series/2023-01-15-hyperband-xgboost/}{Hyperband} optimizer with different budget parameters.
}
}

\section{Super class}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{TunerAsync}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerAsync-optimize}{\code{TunerAsync$optimize()}}
\item \href{#method-TunerAsync-clone}{\code{TunerAsync$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="initialize"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-initialize'><code>mlr3tuning::Tuner$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerAsync-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-TunerAsync-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the tuning on a \link{TuningInstanceAsyncSingleCrit} or \link{TuningInstanceAsyncMultiCrit} until termination.
The single evaluations will be written into the \link{ArchiveAsyncTuning} that resides in the \link{TuningInstanceAsyncSingleCrit}/\link{TuningInstanceAsyncMultiCrit}.
The result will be written into the instance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerAsync$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{TuningInstanceAsyncSingleCrit} | \link{TuningInstanceAsyncMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerAsync-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerAsync-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerAsync$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
