% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppl.R
\name{ppl}
\alias{ppl}
\alias{ppls}
\title{Shorthand Graph Constructor}
\usage{
ppl(.key, ...)

ppls(.keys, ...)
}
\arguments{
\item{.key}{\verb{[character(1)]}\cr
The key of the \code{\link{Graph}} in \code{\link{mlr_graphs}}.}

\item{...}{\code{any}\cr
Additional parameters to give to constructed object.
This may be an argument of the constructor of the
underlying function.}

\item{.keys}{\verb{[character]}\cr
The key of possibly multiple \code{\link{Graph}}s in \code{\link{mlr_graphs}}. If this is named, a
named \code{list} is returned, but unlike \code{\link[=pos]{pos()}} it will not set any \verb{$id} slots.}
}
\value{
\code{\link{Graph}} (for \code{ppl()}) or \code{list} of \code{\link{Graph}}s (for \code{ppls()}).
}
\description{
Creates a \code{\link{Graph}} from \code{\link{mlr_graphs}} from given ID

\code{ppl()} taks a \code{character(1)} and returns a \code{\link{Graph}}. \code{ppls()} takes a \code{character}
vector of any list and returns a \code{list} of possibly muliple \code{\link{Graph}}s.
}
\examples{
\dontshow{ if (requireNamespace("rpart")) \{ }
library("mlr3")

gr = ppl("bagging", graph = po(lrn("regr.rpart")),
  averager = po("regravg", collect_multiplicity = TRUE))
\dontshow{ \} }
}
