% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqFunctionEHVIGH.R
\name{mlr_acqfunctions_ehvigh}
\alias{mlr_acqfunctions_ehvigh}
\alias{AcqFunctionEHVIGH}
\title{Acquisition Function Expected Hypervolume Improvement via Gauss-Hermite Quadrature}
\description{
Expected Hypervolume Improvement.
Computed via Gauss-Hermite quadrature.

In the case of optimizing only two objective functions \link{AcqFunctionEHVI} is to be preferred.
}
\section{Parameters}{

\itemize{
\item \code{"k"} (\code{integer(1)})\cr
Number of nodes per objective used for the numerical integration via Gauss-Hermite quadrature.
Defaults to \code{15}.
For example, if two objectives are to be optimized, the total number of nodes will therefore be 225 per default.
Changing this value after construction requires a call to \verb{$update()} to update the \verb{$gh_data} field.
\item \code{"r"} (\code{numeric(1)})\cr
Pruning rate between 0 and 1 that determines the fraction of nodes of the Gauss-Hermite quadrature rule that are ignored based on their weight value (the nodes with the lowest weights being ignored).
Default is \code{0.2}.
Changing this value after construction does not require a call to \verb{$update()}.
}
}

\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)
  library(data.table)

  fun = function(xs) {
    list(y1 = xs$x^2, y2 = (xs$x - 2) ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y1 = p_dbl(tags = "minimize"), y2 = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchMultiCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  instance$eval_batch(data.table(x = c(-6, -5, 3, 9)))

  learner = default_gp()

  surrogate = srlrn(list(learner, learner$clone(deep = TRUE)), archive = instance$archive)

  acq_function = acqf("ehvigh", surrogate = surrogate)

  acq_function$surrogate$update()
  acq_function$update()
  acq_function$eval_dt(data.table(x = c(-1, 0, 1)))
}
}
\references{
\itemize{
\item Rahat, Alma, Chugh, Tinkle, Fieldsend, Jonathan, Allmendinger, Richard, Miettinen, Kaisa (2022).
\dQuote{Efficient Approximation of Expected Hypervolume Improvement using Gauss-Hermit Quadrature.}
In Rudolph, Günter, Kononova, V. A, Aguirre, Hernán, Kerschke, Pascal, Ochoa, Gabriela, Tušar, Tea (eds.), \emph{Parallel Problem Solving from Nature -- PPSN XVII}, 90--103.
}
}
\seealso{
Other Acquisition Function: 
\code{\link{AcqFunction}},
\code{\link{mlr_acqfunctions}},
\code{\link{mlr_acqfunctions_aei}},
\code{\link{mlr_acqfunctions_cb}},
\code{\link{mlr_acqfunctions_ehvi}},
\code{\link{mlr_acqfunctions_ei}},
\code{\link{mlr_acqfunctions_eips}},
\code{\link{mlr_acqfunctions_mean}},
\code{\link{mlr_acqfunctions_multi}},
\code{\link{mlr_acqfunctions_pi}},
\code{\link{mlr_acqfunctions_sd}},
\code{\link{mlr_acqfunctions_smsego}},
\code{\link{mlr_acqfunctions_stochastic_cb}},
\code{\link{mlr_acqfunctions_stochastic_ei}}
}
\concept{Acquisition Function}
\section{Super classes}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{\link[mlr3mbo:AcqFunction]{mlr3mbo::AcqFunction}} -> \code{AcqFunctionEHVIGH}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ys_front}}{(\code{matrix()})\cr
Approximated Pareto front.
Signs are corrected with respect to assuming minimization of objectives.}

\item{\code{ref_point}}{(\code{numeric()})\cr
Reference point.
Signs are corrected with respect to assuming minimization of objectives.}

\item{\code{hypervolume}}{(\code{numeric(1)}).
Current hypervolume of the approximated Pareto front with respect to the reference point.}

\item{\code{gh_data}}{(\code{matrix()})\cr
Data required for the Gauss-Hermite quadrature rule in the form of a matrix of dimension (k x 2).
Each row corresponds to one Gauss-Hermite node (column \code{"x"}) and corresponding weight (column \code{"w"}).
Computed via \link[fastGHQuad:gaussHermiteData]{fastGHQuad::gaussHermiteData}.
Nodes are scaled by a factor of \code{sqrt(2)} and weights are normalized under a sum to one constraint.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqFunctionEHVIGH-new}{\code{AcqFunctionEHVIGH$new()}}
\item \href{#method-AcqFunctionEHVIGH-update}{\code{AcqFunctionEHVIGH$update()}}
\item \href{#method-AcqFunctionEHVIGH-clone}{\code{AcqFunctionEHVIGH$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_dt"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_dt'><code>mlr3mbo::AcqFunction$eval_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="eval_many"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-eval_many'><code>mlr3mbo::AcqFunction$eval_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqFunction" data-id="reset"><a href='../../mlr3mbo/html/AcqFunction.html#method-AcqFunction-reset'><code>mlr3mbo::AcqFunction$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionEHVIGH-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionEHVIGH-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionEHVIGH$new(surrogate = NULL, k = 15L, r = 0.2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate}}{(\code{NULL} | \link{SurrogateLearnerCollection}).}

\item{\code{k}}{(\code{integer(1)}).}

\item{\code{r}}{(\code{numeric(1)}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionEHVIGH-update"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionEHVIGH-update}{}}}
\subsection{Method \code{update()}}{
Update the acquisition function and set \code{ys_front}, \code{ref_point}, \code{hypervolume} and \code{gh_data}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionEHVIGH$update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqFunctionEHVIGH-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqFunctionEHVIGH-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqFunctionEHVIGH$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
