% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerPredRate}
\alias{mizerPredRate}
\title{Get predation rate needed to project standard mizer model}
\usage{
mizerPredRate(params, n, n_pp, n_other, t, feeding_level, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{feeding_level}{An array (species x size) with the feeding level as
calculated by \code{\link[=getFeedingLevel]{getFeedingLevel()}}.}

\item{...}{Unused}
}
\value{
A named two dimensional array (predator species x prey size) with the
predation rate, where the prey size runs over fish community plus resource
spectrum.
}
\description{
Calculates the potential rate (in units 1/year) at which a prey individual of
a given size \eqn{w} is killed by predators from species \eqn{j}. In formulas
\deqn{{\tt pred\_rate}_j(w_p) = \int \phi_j(w,w_p) (1-f_j(w)) 
  \gamma_j(w) N_j(w) \, dw.}{pred_rate_j(w_p) = \int\phi_i(w,w_p) (1-f_i(w)) 
  \gamma_i(w) N_i(w) dw.}
This potential rate is used in the function \code{\link[=mizerPredMort]{mizerPredMort()}} to
calculate the realised predation mortality rate on the prey individual.
You would not usually call this
function directly but instead use \code{\link[=getPredRate]{getPredRate()}}, which then calls this
function unless an alternative function has been registered, see below.
}
\section{Your own predation rate function}{

By default \code{\link[=getPredRate]{getPredRate()}} calls \code{\link[=mizerPredRate]{mizerPredRate()}}. However you can
replace this with your own alternative predation rate function. If
your function is called \code{"myPredRate"} then you register it in a MizerParams
object \code{params} with

\if{html}{\out{<div class="sourceCode">}}\preformatted{params <- setRateFunction(params, "PredRate", "myPredRate")
}\if{html}{\out{</div>}}

Your function will then be called instead of \code{\link[=mizerPredRate]{mizerPredRate()}}, with
the same arguments.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
