## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(minimapR)

## ----installation, eval = FALSE-----------------------------------------------
# minimap2_installation()

## ----check--------------------------------------------------------------------
minimap2_check()
samtools_check()

## ----download-----------------------------------------------------------------
tmp_folder <- tempdir()
cat("Temporary folder is:", tmp_folder, "\n")
href_url <- "https://github.com/jake-bioinfo/minimapR/raw/master/inst/extdata/GRCh38_chr1_130k.fa.gz"
hfq_url <- "https://github.com/jake-bioinfo/minimapR/raw/master/inst/extdata/ont_hs_sample.fastq.gz"
yref_url <- "https://github.com/jake-bioinfo/minimapR/raw/master/inst/extdata/S288C_ref_genome.fasta.gz"
yfq_url <- "https://github.com/jake-bioinfo/minimapR/raw/master/inst/extdata/yeast_sample_hifi.fastq.gz"
url_list <- c(href_url, hfq_url, yref_url, yfq_url)
lapply(url_list, function(x) download.file(x, destfile = file.path(tmp_folder, basename(x))))

# Contents of the temporary folder
cat("Contents of the temporary folder are:", "\n")
fa_list <- list.files(tmp_folder, pattern = ".fa", full.names = TRUE)
fa_list

## ----align--------------------------------------------------------------------
# Human ONT alignment
h_out <- file.path(tmp_folder, "ont_hs_sample")
h_alignment <- minimap2(reference = fa_list[1], 
                        query_sequences = fa_list[2], 
                        output_file_prefix = h_out, 
                        preset_string = "map-ont", 
                        threads = 4, 
                        return = TRUE, 
                        verbose = FALSE)

# Yeast HIFI alignment
y_out <- file.path(tmp_folder, "yeast_sample_hifi")
y_alignment <- minimap2(reference = fa_list[3], 
                        query_sequences = fa_list[4], 
                        output_file_prefix = y_out, 
                        preset_string = "map-hifi", 
                        threads = 4, 
                        return = TRUE, 
                        verbose = TRUE)

# Check the alignment
cat("Alignment for the human sample is:\n")
h_alignment[1:5, 1:7]
cat("Alignment for the yeast sample is:\n")
y_alignment[1:5, 1:7]

## ----cleanup------------------------------------------------------------------
# Clean up
unlink(tmp_folder, recursive = TRUE)
sessionInfo()

