% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models.R
\name{get_difference}
\alias{get_difference}
\title{Calculate the difference in the mean of the metric for two groups}
\usage{
get_difference(sub_data, group_name, metric)
}
\arguments{
\item{sub_data}{subset of the merged performance data frame for two groups}

\item{group_name}{name of column with group variable}

\item{metric}{metric to compare}
}
\value{
numeric difference in the average metric between the two groups
}
\description{
Calculate the difference in the mean of the metric for two groups
}
\examples{
\dontrun{
df <- dplyr::tibble(
  condition = c("a", "a", "b", "b"),
  AUC = c(.2, 0.3, 0.8, 0.9)
)
get_difference(df, "condition", "AUC")
}
}
\author{
Courtney Armour, \email{armourc@umich.edu}
}
\keyword{internal}
