% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantile.R
\name{weighted.tabulate}
\alias{weighted.tabulate}
\title{Weighted Tabulation for Vectors}
\usage{
weighted.tabulate(bin, w = NULL, nbins = max(1L, bin, na.rm = TRUE))
}
\arguments{
\item{bin}{a numeric vector of positive integers, or a factor.}

\item{w}{a numeric vector of the sample weights for each value in \code{bin}.}

\item{nbins}{the number of bins to be used.}
}
\value{
\code{weighted.tabulate()} returns an numeric vector.
}
\description{
\code{weighted.tabulate()} returns the sum of weights for each integer in the vector \code{bin}.
}
\details{
\code{weighted.tabulate()} is a wrapper function of \code{tabulate()} to reflect sample weights.
This function is used in \code{factor.encoder()} to enable weights-based encoding.
}
\seealso{
\code{\link{weighted.quantile}}
}
\keyword{internal}
