% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_effect.R
\name{mid.effect}
\alias{mid.effect}
\alias{mid.f}
\title{Evaluate Single MID Component Functions}
\usage{
mid.effect(object, term, x, y = NULL)

mid.f(object, term, x, y = NULL)
}
\arguments{
\item{object}{a "mid" object.}

\item{term}{a character string specifying the component function (term) to evaluate.}

\item{x}{a vector of values for the first variable in the term. If a matrix or data frame is provided, values of the related variables are extracted from it.}

\item{y}{a vector of values for the second variable in an interaction term.}
}
\value{
\code{mid.effect()} returns a numeric vector of the calculated term contributions, Wwith the same length as \code{x} and \code{y}.
}
\description{
\code{mid.effect()} calculates the contribution of a single component function of a fitted MID model.
It serves as a low-level helper function for making predictions or for direct analysis of a term's effect.

\code{mid.f()} is a convenient shorthand for \code{mid.effect()}.
}
\details{
\code{mid.effect()} is a low-level function designed to calculate the contribution of a single component function.
Unlike \code{predict.mid()}, which is designed to return total model predictions, \code{mid.effect()} is more flexible.
It accepts vectors, as well as data frames, as input for \code{x} and \code{y}, making it particularly useful for visualizing a component's effect in combination with other functions, such as \code{graphics::curve()}.

For a main effect, the function evaluates the component function \eqn{f_j(x_j)} for a vector of values \eqn{x_j}.
For an interaction, it evaluates \eqn{f_{jk}(x_j, x_k)} using vectors \eqn{x_j} and \eqn{x_k}.
}
\examples{
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, data = airquality, lambda = 1)

# Visualize the main effect of "Wind"
curve(mid.effect(mid, term = "Wind", x), from = 0, to = 25)

# Visualize the interaction of "Wind" and "Temp"
curve(mid.f(mid, "Wind:Temp", x, 50), 0, 25)
curve(mid.f(mid, "Wind:Temp", x, 60), 0, 25, add = TRUE, lty = 2)
curve(mid.f(mid, "Wind:Temp", x, 70), 0, 25, add = TRUE, lty = 3)
}
\seealso{
\code{\link{interpret}}, \code{\link{predict.mid}}
}
