% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orfs.R
\name{orfSignature}
\alias{orfSignature}
\title{Signature for each ORF}
\usage{
orfSignature(orf.table, full = TRUE)
}
\arguments{
\item{orf.table}{A \code{tibble} with ORF information.}

\item{full}{Logical indicating type of signature.}
}
\value{
A text vector with the \code{Signature} for each ORF.
}
\description{
Creates a signature text for orfs in an \code{orf.table}.
}
\details{
A signature is a text that uniquely identifies each ORF in an
\code{orf.table}, which is a GFF-table with columns \code{Seqid}, \code{Start},
\code{End} and \code{Strand}.

The full signature (\code{full = TRUE}) contains the \code{Seqid}, \code{Start},
\code{End} and \code{Strand} information for each ORF, separated by 
semicolon \code{";"}. This text is always unique 
to each ORF. If \code{full = FALSE} the \code{Signature} will not contain 
the starting position information for each ORF. This means all nested ORFs ending 
at the same stop-codon will then get identical \code{Signature}s. This is 
useful for identifying which ORFs are nested within the same LORF.

Note that the signature you get with \code{full = FALSE} contains \code{Seqid}, 
then \code{End} if on the positive \code{Strand}, \code{Start} otherwise, and then
the \code{Strand}.
}
\examples{
# Using a genome file in this package
genome.file <- file.path(path.package("microseq"),"extdata","small.fna")

# Reading genome and finding orfs
genome <- readFasta(genome.file)
orf.tbl <- findOrfs(genome)

# Compute signatures
signature.full <- orfSignature(orf.tbl)
signature.reduced <- orfSignature(orf.tbl, full = FALSE)

}
\seealso{
\code{\link{findOrfs}}.
}
\author{
Lars Snipen.
}
