% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_RR.R
\name{es_from_rr_pval}
\alias{es_from_rr_pval}
\title{Convert a risk ratio value and its p-value to various effect size measures}
\usage{
es_from_rr_pval(
  rr,
  logrr,
  rr_pval,
  baseline_risk,
  n_exp,
  n_nexp,
  n_cases,
  n_controls,
  rr_to_or = "metaumbrella",
  smd_to_cor = "viechtbauer",
  reverse_rr_pval
)
}
\arguments{
\item{rr}{risk ratio value}

\item{logrr}{log risk ratio value}

\item{rr_pval}{p-value of the risk ratio}

\item{baseline_risk}{proportion of cases in the non-exposed group (only required for the \code{rr_to_or = "grant_CI"} and \code{rr_to_or = "grant_2x2"} arguments).}

\item{n_exp}{number of participants in the exposed group (only required for the \code{rr_to_or = "grant_CI"}, \code{rr_to_or = "grant_2x2"} arguments).}

\item{n_nexp}{number of participants in the non-exposed group (only required for the \code{rr_to_or = "grant_CI"}, \code{rr_to_or = "grant_2x2"} arguments).}

\item{n_cases}{number of cases/events}

\item{n_controls}{number of controls/no-event}

\item{rr_to_or}{formula used to convert the \code{rr} value into an odds ratio (see details).}

\item{smd_to_cor}{formula used to convert the SMD value (converted from RR) into a coefficient correlation (see \code{\link{es_from_cohen_d}}).}

\item{reverse_rr_pval}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab RR\cr
\tab \cr
\code{converted effect size measure} \tab OR + NNT\cr
\tab \cr
\code{required input data} \tab See 'Section 3. Risk Ratio'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert a risk ratio value and its p-value to various effect size measures
}
\details{
This function uses the p-value of the (log) risk ratio to obtain the standard error (Section 6.3.2 in the Cochrane Handbook).
\deqn{logrr\_z = qnorm(rr_pval/2, lower.tail=FALSE)}
\deqn{logrr\_se = |\frac{\log(rr)}{logrr\_z}|}

Then, calculations of \code{\link{es_from_rr_se}} are applied.
}
\examples{
es_rr <- es_from_rr_pval(
  rr = 3.51, rr_pval = 0.001,
  n_cases = 12, n_controls = 68
)
}
\references{
Higgins, J. P., Thomas, J., Chandler, J., Cumpston, M., Li, T., Page, M. J., & Welch, V. A. (Eds.). (2019). Cochrane handbook for systematic reviews of interventions. John Wiley & Sons.
}
