% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcamres.R
\name{plotCooman.simcamres}
\alias{plotCooman.simcamres}
\title{Cooman's plot for SIMCAM results}
\usage{
\method{plotCooman}{simcamres}(
  obj,
  nc = c(1, 2),
  main = "Cooman's plot",
  cgroup = obj$c.ref,
  show.plot = TRUE,
  ...
)
}
\arguments{
\item{obj}{SIMCAM results (object of class \code{simcamres})}

\item{nc}{vector with two values - classes (SIMCA models) to show the plot for}

\item{main}{main plot title}

\item{cgroup}{vector of values to use for color grouping of plot points}

\item{show.plot}{logical, show plot or just return plot data}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows a Cooman's plot for a pair of SIMCA models
}
\details{
The plot is similar to \code{\link{plotCooman.simcam}} but shows points only for this result
object and does not show critical limits (which are part of a model).
}
