% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MclustBounded.R
\name{MclustBounded}
\alias{MclustBounded}
\alias{print.MclustBounded}
\alias{summary.MclustBounded}
\alias{print.summary.MclustBounded}
\title{Model-based clustering for bounded data}
\usage{
MclustBounded(data, ...)

\method{summary}{MclustBounded}(object, classification = TRUE, parameters = FALSE, ...)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame of observations. If a
matrix or data frame, rows correspond to observations and columns correspond
to variables.}

\item{\dots}{Further arguments passed to \code{\link[=densityMclustBounded]{densityMclustBounded()}}. For a full
description of available arguments see the corresponding help page.}

\item{object}{An object of class \code{'MclustBounded'}.}

\item{classification}{A logical, if \code{TRUE} a table of MAP
classification/clustering of observations is printed.}

\item{parameters}{A logical, if \code{TRUE} the estimated parameters of mixture
components are printed.}
}
\value{
Returns an object of class \code{'MclustBounded'}.
}
\description{
Clustering of bounded data via transformation-based approach for Gaussian
mixtures.
}
\details{
For more details see
\code{vignette("mclustAddons")}
}
\references{
Scrucca L. (2019) A transformation-based approach to Gaussian
mixture density estimation for bounded data. \emph{Biometrical Journal},
61:4, 873–888. \doi{doi:10.1002/bimj.201800174}
}
\seealso{
\code{\link[=densityMclustBounded]{densityMclustBounded()}}, \code{\link[=predict.MclustBounded]{predict.MclustBounded()}}, \code{\link[=plot.MclustBounded]{plot.MclustBounded()}}.
}
\author{
Luca Scrucca
}
