% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{mclustMarginalParams}
\alias{mclustMarginalParams}
\alias{gmm2margParams}
\title{Marginal parameters from fitted GMMs via mclust}
\usage{
mclustMarginalParams(object, ...)

gmm2margParams(pro, mu, sigma, ...)
}
\arguments{
\item{object}{An object of class \code{Mclust} or \code{densityMclust}.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{pro}{A vector of mixing proportions for each mixture component.}

\item{mu}{A matrix of mean vectors for each mixture component. For
a \eqn{d}-variate dataset on \eqn{G} components, the matrix has dimension
\eqn{(d \times G)}.}

\item{sigma}{An array of covariance matrices for each mixture component.
For a \eqn{d}-variate dataset on \eqn{G} components, the array has dimension
\eqn{(d \times d \times G)}.}
}
\value{
Returns a list of two components for the mean and covariance of the
marginal distribution.
}
\description{
Function to compute the marginal parameters from a fitted Gaussian mixture models.
}
\details{
Given a \eqn{G}-component GMM with estimated mixture weight \eqn{\pi_k},
mean vector \eqn{\mu_{k}}, and covariance matrix \eqn{\Sigma_{k}}, for
mixture component \eqn{k = 1, \dots, G}, then the marginal distribution has:
\itemize{
\item mean vector
\deqn{\mu = \sum_{k=1}^G \pi_k \mu_k}
\item covariance matrix
\deqn{\Sigma = \sum_{k=1}^G \pi_k \Sigma_k + \pi_k (\mu_k - \mu)'(\mu_k -
\mu)}
}
}
\examples{
x = iris[,1:4]
mod = Mclust(x, G = 3)
mod$parameters$pro
mod$parameters$mean
mod$parameters$variance$sigma
mclustMarginalParams(mod)

}
\references{
Frühwirth-Schnatter S. (2006) \emph{Finite Mixture and Markov
Switching Models}, Springer, Sec. 6.1.1
}
\seealso{
\code{\link[mclust:Mclust]{mclust::Mclust()}}, \code{\link[mclust:densityMclust]{mclust::densityMclust()}}.
}
\author{
Luca Scrucca
}
