% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Procedures.R
\name{dotest}
\alias{dotest}
\title{SupF, UDMax & WDMax testing procedure}
\usage{
dotest(
  y_name,
  z_name = NULL,
  x_name = NULL,
  data,
  m = 5,
  eps = 1e-05,
  eps1 = 0.15,
  maxi = 10,
  fixb = 0,
  betaini = 0,
  printd = 0,
  prewhit = 1,
  robust = 1,
  hetdat = 1,
  hetvar = 1,
  hetq = 1,
  hetomega = 1,
  const = 1
)
}
\arguments{
\item{y_name}{matrix of dependent variable}

\item{z_name}{matrix of regressors which coefficients are allowed to change
across regimes.}

\item{x_name}{matrix of regressors which coefficients are constant across
regimes.}

\item{data}{the data set for estimation}

\item{m}{maximum number of breaks}

\item{eps}{convergence criterion for iterative recursive computation}

\item{eps1}{trimming level}

\item{maxi}{maximum number of iterations}

\item{fixb}{option to use fixed initial input \eqn{\beta}. If \code{1},
the model will use values given in \code{betaini}. If \code{0}, betaini is skipped}

\item{betaini}{Initial \eqn{beta_0} to use in estimation (Must be a \verb{p x 1} matrix, where p is number of x variables)}

\item{printd}{Print option for model estimation. \code{default} = 0, to
suppress intermediate outputs printing to console}

\item{prewhit}{option to use AR(1) for prewhitening}

\item{robust}{set to \code{1} to allow for heterogeneity
and autocorrelation in the residuals, \code{0} otherwise.
The method used is \emph{Andrews(1991)} automatic bandwidth with AR(1) approximation with quadratic
kernel. Note: Do not set to \code{1} if lagged dependent variables are
included as regressors.}

\item{hetdat}{option for the construction of the F tests. Set to 1 if want to
allow different moment matrices of the regressors across segments.
If \code{hetdat} = \code{0}, the same moment matrices are assumed for each segment
and estimated from the ful sample. It is recommended to set
\code{hetdat}=\code{1} if number of regressors \code{x} > \code{0}.}

\item{hetvar}{option for the construction of the F tests.Set to \code{1}
if users want to allow for the variance of the residuals to be different across segments.
If \code{hetvar}=\code{0}, the variance of the residuals is assumed constant
across segments and constructed from the full sample. \code{hetvar}=\code{1} when \code{robust} =\code{1})}

\item{hetq}{used in the construction of the confidence intervals for the break
dates. If \code{hetq}=\code{0}, the moment matrix of the data is assumed identical
across segments}

\item{hetomega}{used in the construction of the confidence intervals for the break
dates. If \code{hetomega}=\code{0}, the long run covariance matrix of zu is
assumed identical across segments
(the variance of the errors u if \code{robust}={0})}

\item{const}{indicates whether the regression model include an
intercept changing across regimes. Default value is 1}
}
\value{
A list that contains following:
\itemize{
\item{ftest: SupF test of 0 vs m (1 to maximum) breaks statistics}
\item{cv_supF: Critical values for Sup F test }
\item{cv_Dmax: Critical values for Double Max test}
\item{supF1: table summarizing the SupF test (for viewing purposes)}
\item{UDMax: table summarizing the Double Max test (including UDMax statistics and CVs)}
}
}
\description{
\code{dotest()} compute the test statistics and report the critical values of
the 2 main supF tests below:
\itemize{
\item{SupF test of 0 vs m breaks}
\item{Double Max test proposed by Perron and Bai, 1998}
}
}
