% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Procedures.R
\name{doorder}
\alias{doorder}
\title{Estimating number of breaks via information criterion}
\usage{
doorder(
  y_name,
  z_name = NULL,
  x_name = NULL,
  data,
  m = 5,
  eps = 1e-05,
  eps1 = 0.15,
  maxi = 10,
  fixb = 0,
  betaini = 0,
  printd = 0,
  ic = "KT",
  const = 1,
  h = NULL,
  prewhit = 1,
  hetdat = 1,
  hetq = 1,
  hetomega = 1,
  hetvar = 1,
  robust = 1
)
}
\arguments{
\item{y_name}{name of dependent variable in the data set}

\item{z_name}{name of independent variables in the data set which coefficients are allowed to change
across regimes. \code{default} is vector of 1 (Mean-shift model)}

\item{x_name}{name of independent variables in the data set which coefficients are constant across
regimes. \code{default} is \code{NULL}}

\item{data}{name of data set used}

\item{m}{maximum number of breaks}

\item{eps}{convergence criterion for iterative recursive computation}

\item{eps1}{value of trimming (in percentage) for the construction
and critical values. Minimal segment length \code{h} will be set
at \code{default} = int(\code{eps1}*T) (T is total sample size).
\itemize{
\item{\code{eps1=0.05} Maximal value of \code{m} = 10}
\item{\code{eps1=0.10} Maximal value of \code{m} = 8}
\item{\code{eps1=.15} Maximal value of \code{m} = 5}
\item{\code{eps1=.20} Maximal value of \code{m} = 3}
\item{\code{eps1=.25} Maximal value of \code{m} = 2}
\item{\code{eps1=0} This option allows users to explicitly specify
minimum segment length \code{h} parameters}}}

\item{maxi}{maximum number of iterations}

\item{fixb}{option to use fixed initial input \eqn{\beta}. If \code{1},
the model will use values given in \code{betaini}. If \code{0}, betaini is skipped}

\item{betaini}{Initial \eqn{beta_0} to use in estimation}

\item{printd}{Print option for model estimation. \code{default} = 0, to
suppress intermediate outputs printing to console}

\item{ic}{indicator which information criterion is used in selecting number of breaks:
\verb{\{'KT','BIC','LWZ'\}}. The default value is \code{'KT'}}

\item{const}{indicates whether the regression model include an
intercept changing across regimes. Default value is 1}

\item{h}{Minimum segment length of regime considered in estimation. If users want to specify a particular value, please set \code{eps1=0}}

\item{prewhit}{set to \code{1} to apply AR(1) prewhitening prior to estimating
the long run covariance matrix.}

\item{hetdat}{option for the construction of the F tests. Set to 1 if want to
allow different moment matrices of the regressors across segments.
If \code{hetdat} = \code{0}, the same moment matrices are assumed for each segment
and estimated from the ful sample. It is recommended to set
\code{hetdat}=\code{1} if number of regressors \code{x} > \code{0}.}

\item{hetq}{used in the construction of the confidence intervals for the break
dates. If \code{hetq}=\code{0}, the moment matrix of the data is assumed identical
across segments}

\item{hetomega}{used in the construction of the confidence intervals for the break
dates. If \code{hetomega}=\code{0}, the long run covariance matrix of zu is
assumed identical across segments
(the variance of the errors u if \code{robust}={0})}

\item{hetvar}{option for the construction of the F tests.Set to \code{1}
if users want to allow for the variance of the residuals to be different across segments.
If \code{hetvar}=\code{0}, the variance of the residuals is assumed constant
across segments and constructed from the full sample. \code{hetvar}=\code{1} when \code{robust} =\code{1})}

\item{robust}{set to \code{1} to allow for heterogeneity
and autocorrelation in the residuals, \code{0} otherwise.
The method used is \emph{Andrews(1991)} automatic bandwidth with AR(1) approximation with quadratic
kernel. Note: Do not set to \code{1} if lagged dependent variables are
included as regressors.}
}
\value{
A list of class \code{model} that contains one of the following:
\item{mBIC}{change model with number of breaks selected by BIC}
\item{mLWZ}{change model with number of breaks selected by LWZ}
\item{mKT}{change model with number of breaks selected by KT}
}
\description{
\code{doorder()} estimates the number of breaks
using one of the following information criteria:
\itemize{\item modified Bayesian information criterion by Kurozumi and Tuvaandorj, 2011,
\item modified Schwarz information criterion by Liu, Wu and Zidek, 1997,
\item Bayesian information criterion by Yao, 1988 } and the structural break model
corresponding to estimated number of breaks
}
\examples{
doorder('rate',data=real,ic=c('BIC'))

}
\references{
Liu J, Wu S, Zidek JV (1997). \emph{"On Segmented Multivariate Regressions"},
Statistica Sinica, 7, 497-525.
Yao YC (1988). \emph{"Estimating the Number of Change-points via Schwartz Criterion"},
Statistics and Probability Letters, 6, 181-189.
Kurozumi E, Tuvaandorj P (2011). \emph{"Model Selection Criteria in Multivariate Models with
Multiple Structural Changes"}, Journal of Econometrics 164, 218-238.
}
