% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_aggregation_table.R
\name{calculate_pixel_fractions_single_polygon}
\alias{calculate_pixel_fractions_single_polygon}
\title{Calculate fractional pixels in a polygon}
\usage{
calculate_pixel_fractions_single_polygon(polygon, id_raster, polygon_id = NULL)
}
\arguments{
\item{polygon}{\link[terra:SpatVector-class]{terra::SpatVector} object of length 1. The polygon to calculate
fractional areas across.}

\item{id_raster}{\link[terra:SpatRaster-class]{terra::SpatRaster} object. ID raster created for the set of all
polygons to be considered, created by \code{build_id_raster()}.}

\item{polygon_id}{(optional). ID for this polygon. Must have length 1.}
}
\value{
data.table containing two or three columns:
\itemize{
\item pixel_id: unique pixel ID from the ID raster
\item area_fraction: fraction of the pixel area falling within this polygon
\item polygon_id (optional): If \code{polygon_id} was defined, it is added to the table
}
}
\description{
Calculate the fraction of each pixel's area that falls within a single
polygon
}
\details{
This is a helper function called by \code{build_aggregation_table()}.
}
\examples{
\dontrun{
  polygons <- sf::st_read(system.file('extdata/Benin_communes.gpkg', package = 'mbg'))
  id_raster <- build_id_raster(polygons)
  pixel_fractions <- calculate_pixel_fractions_single_polygon(
    polygon = polygons[1, ], id_raster
  )
  head(pixel_fractions)
}

}
\seealso{
build_aggregation_table
}
\concept{aggregation}
