% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_aggregation_table.R
\name{build_aggregation_table}
\alias{build_aggregation_table}
\title{Build aggregation table}
\usage{
build_aggregation_table(polygons, id_raster, polygon_id_field, verbose = FALSE)
}
\arguments{
\item{polygons}{\link[terra:SpatVector-class]{terra::SpatVector} object. Should contain a unique ID field.}

\item{id_raster}{\link[terra:SpatRaster-class]{terra::SpatRaster} object. ID raster created by \code{build_id_raster()}
for the polygons object. Should have the same CRS as \code{polygons} and completely cover
it.}

\item{polygon_id_field}{(\code{character(1)}) Unique identifier field in \code{polygons}.}

\item{verbose}{(\code{logical(1)}, default FALSE) Show progress for building aggregation
rows for each polygon?}
}
\value{
data.table with fields:
\itemize{
\item polygon_id: Unique polygon identifier
\item pixel_id: unique pixel ID from the ID raster
\item masked_pixel_id: Index counting only non-NA pixels from the ID raster
\item area_fraction: fraction of the pixel area falling within this polygon
\item Merged fields from the table of polygons
}
}
\description{
Build a table to quickly aggregate from pixels to polygons
}
\examples{
\dontrun{
  polygons <- sf::st_read(system.file('extdata/Benin_communes.gpkg', package = 'mbg'))
  id_raster <- build_id_raster(polygons)
  aggregation_table <- build_aggregation_table(
    polygons, id_raster, polygon_id_field = 'commune_code'
  )
}

}
\seealso{
calculate_pixel_fractions_single_polygon()
}
\concept{aggregation}
