% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dailyOMP.R
\name{dailyOMP}
\alias{dailyOMP}
\title{Calculate daily outcrossed mating potential}
\usage{
dailyOMP(
  scene,
  k = 3,
  days = NULL,
  gamma = 1/13.3,
  nn.constant = FALSE,
  sum = FALSE,
  mean = FALSE
)
}
\arguments{
\item{scene}{a matingScene object}

\item{k}{integer, number of nearest neighbors to use in calculating OMP}

\item{days}{the day or range of days to calculate OMP for, default is all days in a scene (see Details)}

\item{gamma}{parameter of exponential decay to be used in calculating OMP (defaults to 1/13)}

\item{nn.constant}{logical; indicates whether the nearest neighbors used in calculations should be the nearest on a given day (\code{nn.constant = FALSE}) or the nearest neighbors over an entire season (\code{nn.constant = TRUE})}

\item{sum}{logical; indicates if the return should be a sum of an individual's daily outcrossed mating potential over the range specified by days}

\item{mean}{logical; indicates if the return should be the mean of an individual's daily outcrossed mating potential over the range of days that the individual was receptive to mating}
}
\value{
a named matrix with a row for each id and a column for each day, and entries corresponding to ids' OMP each day
}
\description{
dailyOMP generates an OMP object giving the daily outcrossed mating potential of individuals based on k nearest neighbors
}
\details{
Daily outcrossed mating potential is a weighted average of an individual's distance to their nearest neighbors on a given day (Wagenius et al. 2007). The days to calculate OMP for should be input as integers relative to the first day of flowering, as they are in the start and end columns of a matingScene object. If the number of ids receptive on a day is less than k, OMP will be calculated for the maximum number of neighbors.
}
\examples{
pop <- simulateScene()
omp <- dailyOMP(pop)
omp.1 <- dailyOMP(pop, nn.constant = TRUE) # same nearest neighbors throughout the season
omp.2 <- dailyOMP(pop, nn.constant = FALSE) # nearest flowering neighbors
}
\references{
Wagenius, S., E. Lonsdorf, and C. Neuhauser. 2007. Patch aging and the S-Allee effect: breeding system effects on the demographic response of plants to habitat fragmentation. \emph{American Naturalist} \strong{169}:383-397.
}
\seealso{
\code{\link{makeScene}}, \code{\link{proximity}}, \code{\link{synchrony}}, \code{\link{receptivityByDay}}
}
\author{
Amy Waananen
}
