% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{set_style}
\alias{set_style}
\title{Update the style of a map}
\usage{
set_style(map, style, config = NULL, diff = TRUE)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} function, or a proxy object.}

\item{style}{The new style URL to be applied to the map.}

\item{config}{A named list of options to be passed to the style config.}

\item{diff}{A boolean that attempts a diff-based update rather than re-drawing the full style. Not available for all styles.}
}
\value{
The modified map object.
}
\description{
Update the style of a map
}
\examples{
\dontrun{
map <- mapboxgl(
    style = mapbox_style("streets"),
    center = c(-74.006, 40.7128),
    zoom = 10,
    access_token = "your_mapbox_access_token"
)

# Update the map style in a Shiny app
observeEvent(input$change_style, {
    mapboxgl_proxy("map", session) \%>\%
        set_style(mapbox_style("dark"), config = list(showLabels = FALSE), diff = TRUE)
})
}
}
