% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_generate.R, R/manip_correlation.R
\name{make_random}
\alias{make_random}
\alias{generate_random}
\alias{generate_configuration}
\alias{generate_man}
\alias{generate_utilities}
\alias{generate_permutation}
\title{Making unconditional and conditional random networks}
\usage{
generate_random(n, p = 0.5, directed = FALSE, with_attr = TRUE)

generate_configuration(.data)

generate_man(n, man = NULL)

generate_utilities(n, steps = 1, volatility = 0, threshold = 0)

generate_permutation(.data, with_attr = TRUE)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A manynet-compatible object,
a network of the same dimensions will be created.
}}

\item{p}{Proportion of possible ties in the network that are realised or,
if integer greater than 1, the number of ties in the network.}

\item{directed}{Whether to generate network as directed. By default FALSE.}

\item{with_attr}{Logical whether any attributes of the object
should be retained.
By default TRUE.}

\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{man}{Vector of Mutual, Asymmetric, and Null dyads, respectively.
Can be specified as proportions, e.g. \code{c(0.5, 0.5, 0.5)},
or as a count, e.g. \code{c(10,0,20)}.
Is inferred from \code{n} if it is an existing network object.}

\item{steps}{Number of simulation steps to run.
By default 1: a single, one-shot simulation.
If more than 1, further iterations will update the utilities
depending on the values of the volatility and threshold parameters.}

\item{volatility}{How much change there is between steps.
Only if volatility is more than 1 do further simulation steps make sense.
This is passed on to \code{stats::rnorm} as the \code{sd} or standard deviation
parameter.}

\item{threshold}{This parameter can be used to mute or disregard stepwise
changes in utility that are minor.
The default 0 will recognise all changes in utility,
but raising the threshold will mute any changes less than this threshold.}
}
\value{
By default a \code{tbl_graph} object is returned,
but this can be coerced into other types of objects
using \code{as_edgelist()}, \code{as_matrix()},
\code{as_tidygraph()}, or \code{as_network()}.

By default, all networks are created as undirected.
This can be overruled with the argument \code{directed = TRUE}.
This will return a directed network in which the arcs are
out-facing or equivalent.
This direction can be swapped using \code{to_redirected()}.
In two-mode networks, the directed argument is ignored.
}
\description{
These functions are similar to the \verb{create_*} functions,
but include some element of randomisation.
They are particularly useful for creating a distribution of networks
for exploring or testing network properties.
\itemize{
\item \code{generate_random()} generates a random network with ties appearing at some probability.
\item \code{generate_configuration()} generates a random network consistent with a
given degree distribution.
\item \code{generate_man()} generates a random network conditional on the dyad census
of Mutual, Asymmetric, and Null dyads, respectively.
\item \code{generate_utilities()} generates a random utility matrix.
}

These functions can create either one-mode or two-mode networks.
To create a one-mode network, pass the main argument \code{n} a single integer,
indicating the number of nodes in the network.
To create a two-mode network, pass \code{n} a vector of \emph{two} integers,
where the first integer indicates the number of nodes in the first mode,
and the second integer indicates the number of nodes in the second mode.
As an alternative, an existing network can be provided to \code{n}
and the number of modes, nodes, and directedness will be inferred.
}
\examples{
graphr(generate_random(12, 0.4))
# graphr(generate_random(c(6, 6), 0.4))
}
\references{
\subsection{On random networks}{

Erdos, Paul, and Alfred Renyi. 1959.
"\href{https://www.renyi.hu/~p_erdos/1959-11.pdf}{On Random Graphs I}"
\emph{Publicationes Mathematicae}. 6: 290–297.
}

\subsection{On configuration models}{

Bollobas, Bela. 1980.
"A Probabilistic Proof of an Asymptotic Formula for the Number of Labelled Regular Graphs".
\emph{European Journal of Combinatorics} 1: 311-316.
}

\subsection{On dyad-census conditioned networks}{

Holland, Paul W., and Samuel Leinhardt. 1976.
“Local Structure in Social Networks.”
In D. Heise (Ed.), \emph{Sociological Methodology}, pp 1-45.
San Francisco: Jossey-Bass.
}
}
\seealso{
Other makes: 
\code{\link{make_cran}},
\code{\link{make_create}},
\code{\link{make_ego}},
\code{\link{make_explicit}},
\code{\link{make_learning}},
\code{\link{make_motifs}},
\code{\link{make_play}},
\code{\link{make_read}},
\code{\link{make_stochastic}},
\code{\link{make_write}}
}
\concept{makes}
