% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General.R
\name{rmfd}
\alias{rmfd}
\alias{rmfd.default}
\title{Generate random variables on the manifold}
\usage{
rmfd(mfd, n, dimIntrinsic, ...)

\method{rmfd}{default}(
  mfd,
  n,
  dimIntrinsic,
  p,
  dist = c("norm", "unif", "exp"),
  totalVar = 1,
  ...
)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{n}{Sample size}

\item{dimIntrinsic}{The intrinsic dimension of the target manifold}

\item{...}{Passed into specific methods}

\item{p}{Optionally, specify the base point of the tangent space, on which random tangent vectors will be generated. Default to the origin of `mfd`.}

\item{dist}{Either a string or a function, describing the distributions. If it is character, then independent univariate r.v. following that distribution with total variance 1 is generated on the tangent space. If it is a function, it should specify the generation of the samples on the tangent space _coordinates_ (with dimension dimIntrinsic), and it must return a matrix for which the columns are the coordinates. Then it will be mapped to the tangent space at the origin and then to the manifold.}

\item{totalVar}{Total variance (sum of diagonal of the covariance matrix) of the tangent random vector}
}
\value{
A matrix with n columns, each containing a random sample on the manifold
}
\description{
By default, random variables are generated by mapping isotropic Gaussian distributions on the tangent space back to the manifold using the exponential map
}
\section{Methods (by class)}{
\itemize{
\item \code{rmfd(default)}: Default method

}}
