% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\docType{data}
\name{Roztoky_PZ_cz}
\alias{Roztoky_PZ_cz}
\title{Municipal Election Data: Roztoky (PZ, CZ)}
\format{
An object of class \code{data.frame} with 1079 rows and 14 columns.
}
\source{
The dataset was compiled primarily from official election results published by
the Czech Statistical Office. Additional contextual or verification information
(such as post-election roles) was obtained from publicly available municipal
records and interviews with local political representatives.
\itemize{
\item \href{https://www.volby.cz/index_en.htm}{Czech Statistical Office}
\item \href{https://www.roztoky.cz/}{Municipality website}
}
}
\usage{
Roztoky_PZ_cz
}
\description{
A dataset containing individual-level candidacy records from municipal
elections in the municipality of Roztoky (district Praha-zapad, Czech Republic).
}
\details{
\tabular{ll}{
   \strong{Dataset overview:} \tab  \cr
   Municipality: \tab Roztoky \cr
   District: \tab Praha-zapad \cr
   Country: \tab Czech Republic \cr
   Number of elections: \tab 8 \cr
   Elections covered: \tab 1994, 1998, 2002, 2006, 2010, 2014, 2018, 2022 \cr
   Number of candidacies (rows): \tab 1079 \cr
   Note: \tab \href{https://www.roztoky.cz/}{Municipality website} \cr
}
}
\section{Description of variables}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   elections \tab Election identifiers (numeric) \cr
   candidate \tab Candidate's full name (character) \cr
   list_name \tab Name of the candidate list (character) \cr
   list_pos \tab Candidate's position on the list (numeric) \cr
   pref_votes \tab Number of preferential votes (numeric) \cr
   elected \tab Logical; TRUE if candidate was elected \cr
   nom_party \tab Nominating party (character) \cr
   pol_affil \tab Political affiliation (character) \cr
   mayor \tab TRUE if elected mayor \cr
   dep_mayor \tab TRUE if elected deputy mayor \cr
   board \tab TRUE if member of the executive board \cr
   gov_support \tab TRUE if supported the local government \cr
   elig_voters \tab Number of eligible voters (numeric) \cr
   ballots_cast \tab Number of ballots cast (numeric) \cr
}


Each record describes one candidate's run for office, including their candidate
list affiliation, position on the list, nominating party, political affiliation,
number of preferential votes, and whether they were elected or held specific
positions (mayor, deputy mayor, member of the executive body).

The dataset also includes contextual election-level information, such as the
number of eligible voters and ballots cast, which can be used to calculate
voter turnout and related indicators. These variables appear only once per
election and constituency (they may be stored in a single candidate row for
that election/constituency)
}

\examples{
# Basic inspection
str(Roztoky_PZ_cz)

# Example of a basic continuity diagram (unformatted version)
\donttest{plot_continuity(Roztoky_PZ_cz, elections = "2002-")}
}
\references{
\itemize{
\item Kubalek, M., & Bubenicek, V. (2012). Charakter lokalni politiky v suburbannim
politickem prostoru (The Nature of Local Politics in Suburban Political Space).
\emph{Acta Politologica}, 4(3), 284-305.
[\href{https://acpo.fsv.cuni.cz/ACPONEN-50-version1-acpo_2012_03_05.pdf}{Full text}]
}
}
\keyword{datasets}
