% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{warning}
\alias{warning}
\title{Warning Messages Log Handler}
\usage{
warning(
  ...,
  call. = TRUE,
  immediate. = FALSE,
  noBreaks. = FALSE,
  domain = NULL,
  .loggit = TRUE,
  echo = TRUE
)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or a single
    condition object.}

\item{call.}{logical, indicating if the call should become part of the
    warning message.}

\item{immediate.}{logical, indicating if the call should be output
    immediately, even if \code{\link[base]{getOption}("warn") <= 0}.}

\item{noBreaks.}{logical, indicating as far as possible the message should
    be output as a single line when \code{options(warn = 1)}.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated, see also the note in \code{\link[base]{stop}}.}

\item{.loggit}{Should \code{loggit()} execute? Defaults to \code{TRUE}.}

\item{echo}{Should \code{loggit()}'s log entry be echoed to the console, as well? Defaults to \code{TRUE}.}
}
\value{
The warning message as \code{\link[base]{character}} string, invisibly.
}
\description{
This function is identical to base R's \code{\link[base:warning]{warning}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
  if (2 < 1) warning("You may want to review that math, and so this is your warning")

}
\seealso{
Other handlers: 
\code{\link{message}()},
\code{\link{stopifnot}()},
\code{\link{stop}()}
}
\concept{handlers}
