% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rotate_logs}
\alias{rotate_logs}
\title{Rotate log file}
\usage{
rotate_logs(rotate_lines = 100000L, logfile = get_logfile())
}
\arguments{
\item{rotate_lines}{The number of log entries to keep in the logfile.}

\item{logfile}{Log file to truncate.}
}
\value{
Invisible \code{NULL}.
}
\description{
Truncates the log file to the line count provided as \code{rotate_lines}.
}
\examples{
  # Truncate "default" log file to 100 lines
  set_logfile()
  for (i in 1:150) {loggit("INFO", i, echo = FALSE)}
  rotate_logs(100)

  # Truncate a different log file to 250 lines
  another_log <- file.path(tempdir(), "another.log")
  set_logfile(another_log)
  for (i in 1:300) {loggit("INFO", i, echo = FALSE)}
  set_logfile() # clears pointer to other log file
  rotate_logs(250, another_log)

}
