% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{message}
\alias{message}
\title{Diagnostic Messages Log Handler}
\usage{
message(..., domain = NULL, appendLF = TRUE, .loggit = TRUE, echo = TRUE)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or (for
    \code{message} only) a single condition object.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated, see also the note in \code{\link[base]{stop}}.}

\item{appendLF}{logical: should messages given as a character string
    have a newline appended?}

\item{.loggit}{Should \code{loggit()} execute? Defaults to \code{TRUE}.}

\item{echo}{Should \code{loggit()}'s log entry be echoed to the console, as well? Defaults to \code{TRUE}.}
}
\value{
Invisible \code{NULL}.
}
\description{
This function is identical to base R's \code{\link[base:message]{message}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
  if (2 < 1) message("Don't say such silly things!")

}
\seealso{
Other handlers: 
\code{\link{stopifnot}()},
\code{\link{stop}()},
\code{\link{warning}()}
}
\concept{handlers}
