% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcc}
\alias{mcc}
\title{MCC [p-value] [iid]}
\usage{
mcc(
  local_score,
  sequence_length,
  score_probabilities,
  sequence_min,
  sequence_max
)
}
\arguments{
\item{local_score}{the observed local score}

\item{sequence_length}{length of the sequence (up to one hundred)}

\item{score_probabilities}{the probabilities for each unique score from lowest to greatest}

\item{sequence_min}{minimum score}

\item{sequence_max}{maximum score}
}
\value{
A double representing the probability of a local score as high as the one given as argument
}
\description{
Calculates an approximated p-value for a given local score value and a medium to long sequence length in the identically and independently distributed model
}
\details{
This methods is actually an improved method of Karlin and produces more precise results. It should be privileged whenever possible. \cr
As with karlin, the method works the better the longer the sequence. Important note : the calculus of the parameter of the distribution uses
the resolution of a polynome which is a function of the score distribution, of order max(score)-min(score). There exists only empirical methods to solve a polynome of order greater that 5
with no warranty of reliable solution.
The found roots are checked internally to the function and an error message is throw in case of inconsistency. In such case, you could try to change your score scheme (in case of discretization)
or use the function \code{\link{karlinMonteCarlo}} .
}
\examples{
mcc(40, 100, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
mcc(40, 10000, c(0.08, 0.32, 0.08, 0.00, 0.08, 0.00, 0.00, 0.08, 0.02, 0.32, 0.02), -6, 4)
}
\seealso{
\code{\link{karlin}}, \code{\link{daudin}}, \code{\link{karlinMonteCarlo}}, \code{\link{monteCarlo}}
}
