% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_bbox.R
\name{st_bbox}
\alias{st_bbox}
\alias{st_bbox.LAS}
\alias{st_bbox.LASheader}
\alias{st_bbox.LAScatalog}
\alias{st_bbox.LAScluster}
\alias{ext,LAS-method}
\alias{ext,LASheader-method}
\alias{ext,LAScatalog-method}
\alias{ext,LAScluster-method}
\title{Bounding box of a LAS* object}
\usage{
\method{st_bbox}{LAS}(obj, ...)

\method{st_bbox}{LASheader}(obj, ...)

\method{st_bbox}{LAScatalog}(obj, ...)

\method{st_bbox}{LAScluster}(obj, ...)

\S4method{ext}{LAS}(x, ...)

\S4method{ext}{LASheader}(x, ...)

\S4method{ext}{LAScatalog}(x, ...)

\S4method{ext}{LAScluster}(x, ...)
}
\arguments{
\item{obj, x}{An object of class \code{LAS*}.}

\item{...}{unused}
}
\value{
A \code{bbox} from sf, or a \code{SpatExtent} from \code{terra}.
}
\description{
Bounding box of a \verb{LAS*} object. \code{st_bbox()} extends \code{sf}, and \code{ext()} extends \code{terra}. The values returned are similar to their
parent functions.
}
\examples{
f <- system.file("extdata", "example.las", package="rlas")
las <- readLAS(f)

st_bbox(las)
ext(las)
}
