context("Test PDF and CDF fit functions")
test_that("Functions work",{

  pars <- c(1.5, 0.9, 1, 0)
  x <- seq(-5, 10, 0.1)

  pdf <- stable_pdf(x, pars)
  cdf <- stable_cdf(x, pars)

  c(0.000615673261644577, 0.000655923775733803, 0.000700475356226434,
    0.000750058400902734, 0.000805598554251076, 0.000868290223322292,
    0.000939701907720569, 0.00102192629523507, 0.00111779197132642,
    0.00123115769637168, 0.00136731388997066, 0.00153351823050943,
    0.00173969174836804, 0.00199929676353968, 0.00233040666838479,
    0.00275695827351455, 0.00331014929212128, 0.0040299068467979,
    0.00496630971833103, 0.00618080161672866, 0.00774699138931219,
    0.00975080684709658, 0.0122897605855203, 0.0154711068847921,
    0.019408724135131, 0.0242186487148854, 0.0300133098569933, 0.0368946607842492,
    0.0449465538350381, 0.054226847205577, 0.0647598379074106, 0.0765296712070581,
    0.089475368020978, 0.103488033094156, 0.118410662130551, 0.13404076829726,
    0.150135818270897, 0.166421230503883, 0.182600470148035, 0.198366600005326,
    0.213414533143784, 0.227453190600611, 0.240216798181658, 0.251474652581297,
    0.261038834849923, 0.268769530085973, 0.274577805891466, 0.278425889135391,
    0.280325144640474, 0.280332088655478, 0.278542857688324, 0.275086597928565,
    0.27011824482044, 0.26381113253705, 0.2563498173374, 0.247923426093159,
    0.238719760432898, 0.228920305692152, 0.218696218329045, 0.208205300014081,
    0.197589913789453, 0.186975758474655, 0.17647139153809, 0.16616837667661,
    0.156141928475077, 0.146451930595097, 0.137144213784557, 0.128251993568323,
    0.119797383021108, 0.111792912107575, 0.104243000626347, 0.0971453460661136,
    0.0904922002153381, 0.0842715189415676, 0.0784679781349634, 0.073063855487239,
    0.0680397827314527, 0.0633753764274419, 0.0590497575881228, 0.0550419716466411,
    0.05133132068965, 0.0478976197284729, 0.0447213882186701, 0.041783987210293,
    0.0390677115279263, 0.036555845326867, 0.0342326883134332, 0.0320835588970798,
    0.0300947795895241, 0.0282536490985021, 0.0265484047895099, 0.0249681785097125,
    0.0235029481813701, 0.0221434870719017, 0.0208813122265791, 0.0197086331994622,
    0.0186183019299639, 0.017603764378033, 0.0166590143425058, 0.0157785497375712,
    0.014957331485084, 0.014190745090065, 0.0134745648982398, 0.0128049209837617,
    0.0121782685788095, 0.0115913599316123, 0.0110412184632013, 0.0105251150838159,
    0.0100405465257797, 0.00958521554949066, 0.00915701288189396,
    0.00875400075158801, 0.00837439789090243, 0.00801656588237373,
    0.00767899673463792, 0.00736030158056657, 0.00705920039827459,
    0.00677451266326491, 0.00650514884733601, 0.00625010268688814,
    0.00600844414987538, 0.00577931303683831, 0.00556191315720757,
    0.00535550702739193, 0.00515941104206961, 0.00497299107460209,
    0.00479565846660841, 0.0046268663704962, 0.00446610641216841,
    0.00431290564423568, 0.00416682376288783, 0.00402745056413684,
    0.00389440361746148, 0.00376732613697953, 0.00364588503216911,
    0.00352976912187269, 0.00341868749686403, 0.00331236801765443,
    0.00321055593547513, 0.00311301262551062, 0.00301951442248354,
    0.00292985154961977, 0.00284382713285766, 0.00276125629292134,
    0.00268196530855961, 0.00260579084486814, 0.00253257924116871,
    0.00246218585342301, 0.00239447444661201, 0.0023293166329246,
    0.00226659135197001) -> pdf_cmp

  c(0.00180888109217932, 0.00187242773384937, 0.00194020905824661,
    0.00201269030651115, 0.00209041901423101, 0.00217404799140175,
    0.00226436715170639, 0.00236234798956263, 0.00246920598986397,
    0.00258648814580555, 0.00271619504690514, 0.00286094959369529,
    0.00302422708991434, 0.00321066389458458, 0.00342646344398415,
    0.00367991856088557, 0.00398206670795084, 0.00434748933078367,
    0.00479525690615977, 0.00535000730655715, 0.00604312668638074,
    0.00691398008747757, 0.00801111500394337, 0.00939333774889927,
    0.0111305428400011, 0.0133041633456879, 0.0160071086721549, 0.0193430683842809,
    0.023425087824142, 0.0283733632481415, 0.0343122586716231, 0.0413666093458177,
    0.049657441944675, 0.0592973023908506, 0.0703854316152289, 0.0830030622275379,
    0.0972091192917345, 0.113036595877826, 0.130489837957606, 0.149542917512163,
    0.170139202388147, 0.192192153296255, 0.215587299602833, 0.240185273301079,
    0.265825720592495, 0.29233186716627, 0.319515488811847, 0.347182033732928,
    0.375135655340777, 0.403183941446163, 0.43114216381501, 0.45883691668134,
    0.486109059875929, 0.51281592794168, 0.5388328079795, 0.564053723801428,
    0.588391591196186, 0.611777827860126, 0.634161512898727, 0.655508194428951,
    0.675798442565503, 0.695026237345797, 0.71319727282068, 0.730327245604108,
    0.746440184113112, 0.761566861945036, 0.775743326961339, 0.789009566924949,
    0.801408323305079, 0.812984057183493, 0.82378206513857, 0.833847738573291,
    0.843225956087574, 0.851960597729051, 0.860094167205587, 0.867667509107187,
    0.874719607746074, 0.88128745507265, 0.887405976019363, 0.893108000724963,
    0.898424274269709, 0.903383495739536, 0.908012379589418, 0.912335733357634,
    0.916376546772562, 0.920156088181174, 0.923694005009966, 0.92700842564635,
    0.930116060707086, 0.933032302147654, 0.935771319071769, 0.938346149432813,
    0.940768787089311, 0.943050263883342, 0.945200726608827, 0.947229508809073,
    0.949145197514242, 0.950955695043935, 0.952668276080615, 0.954289640245977,
    0.955825960435141, 0.957282927173262, 0.95866578926501, 0.95997939100119,
    0.961228206182367, 0.962416369207859, 0.963547703466652, 0.964625747252826,
    0.965653777415378, 0.966634830935375, 0.967571724611869, 0.968467073022615,
    0.969323304912614, 0.970142678151097, 0.970927293385557, 0.971679106510331,
    0.972399940057017, 0.97309149360389, 0.973755353294487, 0.974393000543922,
    0.975005820008463, 0.975595106883644, 0.976162073591777, 0.976707855913605,
    0.977233518613813, 0.977740060605474, 0.978228419694302, 0.978699476939815,
    0.979154060666999, 0.979592950159022, 0.980016879058651, 0.98042653850352,
    0.980822580018077, 0.981205618182912, 0.981576233100338, 0.981934972673323,
    0.982282354713383, 0.982618868891581, 0.982944978545579, 0.983261122354474,
    0.983567715892159, 0.983865153068983, 0.984153807470635, 0.984434033602393,
    0.984706168046206, 0.984970530537386, 0.985227424967167, 0.985477140316814,
    0.985719951528503, 0.98595612031777, 0.98618589593191) -> cdf_cmp

  testthat::expect_true(all.equal(pdf, pdf_cmp))
  testthat::expect_true(all.equal(cdf, cdf_cmp))


})

context("Test stable rnd gen")
test_that("Functions work", {
  N <- 10
  pars <- c(1.25, 0.95, 1.0, 0.0)
  set.seed(1234)
  rnd <- stable_rnd(N, pars)

  c(-0.6190323567540741, 0.8378852752114967, 3.2758322272262475, -2.0222423205975018,
     1.0996882708196980, 1.3202137445154571, 0.4411379495808827,  0.1364792969071682,
     -0.9455257922453373, -1.2398125531067938) -> rnd_cmp

  testthat::expect_true(all.equal(rnd, rnd_cmp))
})
