% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_values.R
\name{replace_values}
\alias{replace_values}
\title{replace values with values from another object}
\usage{
replace_values(x, y, sf)
}
\arguments{
\item{x}{\code{conductanceMatrix}}

\item{y}{\code{conductanceMatrix}}

\item{sf}{\code{sf}}
}
\value{
\code{conductanceMatrix}
}
\description{
Replace values of \code{conductanceMatrix} x with the values of \code{conductanceMatrix} y that coincide with the supplied sf object
}
\details{
The values of \code{conductanceMatrix} x are replaced with the values from \code{conductanceMatrix} y that coincide with the supplied sf object
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

x <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(960745, 4166836)),
crs = terra::crs(r)))
locs <- sf::st_buffer(x = locs, dist = 25000)

y <- update_values(x = x, sf = locs, FUN = function(j) { j + 10})

output <- replace_values(x = x, y = y, sf = locs)

identical(y$conductanceMatrix, output$conductanceMatrix)
}
\author{
Joseph Lewis
}
