% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_exhaustive.R
\name{search_exhaustive}
\alias{search_exhaustive}
\title{Searches the space backwards, prefering more subjects and certain group size
proportions.}
\usage{
search_exhaustive(condition, covariates, halting_test, thresh, props,
  max_removed, tiebreaker = NULL, min_preserved = NULL, print_info = TRUE,
  ...)
}
\arguments{
\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A columnwise matrix containing
covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
which is TRUE iff the conditions are matched.
Signature: halting_test(condition, covariates, thresh).
The following halting tests are part of this package:
\code{\link{t_halt}}, \code{\link{U_halt}},
\code{\link{l_halt}}, \code{\link{ad_halt}},
\code{\link{ks_halt}}, \code{\link{wilks_halt}},
\code{\link{f_halt}}.
You can create the intersection of two or more halting
tests using \code{\link{create_halting_test}}.}

\item{thresh}{The return value of halting_test has to be greater than
or equal to thresh for the matched groups.}

\item{props}{Either the desired proportions (percentage) of the
sample for each condition as a named vector,
or the names of the conditions
for which we prefer to preserve the subjects,
in decreasing order of preference. If not specified, the
(full) sample proportions are used.
This is enforced by the "heuristic1" method,
preferred among configurations with the same number of
total subjects by the "exhaustive" method, and
taken into account by the other methods to some extent.
For example, c(A = 0.4, B = 0.4, C = 0.2) means that
we would like the number of subjects in groups A, B, and
C to be around 40\%, 40\%, and 20\% of the total number of
subjects, respectively. Whereas c("A", "B", "C") means
that if possible, we would like to keep all subjects
in group A, and prefer keeping subjects in B, even if
it results in losing more subjects from C.}

\item{max_removed}{The maximum number of subjects that can be removed from
each group. It must have a valid number for each group.}

\item{tiebreaker}{NULL, or a function similar to halting_test, used to
decide between cases for which halting_test yields
equal values.}

\item{min_preserved}{The minimum number of preserved subjects.
It can be used to ensure that the search will not take
forever to run, but instead fail when a solution is not
found when preserving this number of subjects.}

\item{print_info}{If TRUE, prints summary information on the input and the
results, as well as progress information for the
exhaustive search and random algorithms. Default: TRUE;
can be changed using
\code{\link{set_param}("PRINT_INFO", FALSE)}.}

\item{...}{Consumes extra parameters that are not used by the
search algorithm at hand; this function gives a warning
about the ones whose value is not NULL that their value
is not used.}
}
\value{
All results found by search method in a list. It raises a
        "Convergence failure" error if it cannot find a matched set.
}
\description{
Searches the space backwards, prefering more subjects and certain group size
proportions.
}
\details{
While the search is done in parallel, the search space is enormous and so
it can be very slow in the worst case. It is perhaps most useful as a tool
to study other matching procedures.

You can calculate the maximum possible number of cases to evaluate by
calling estimate_exhaustive().
}

